/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.ConnectExceptionSupport;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.DnsResolver;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.SchemePortResolver;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.UnsupportedSchemeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.io.DetachedSocketFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.Internal;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.HttpHost;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.URIScheme;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.config.Lookup;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.io.SocketConfig;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.io.Closer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.net.NamedEndpoint;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Args;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.TimeValue;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Timeout;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpClientConnectionOperator
implements HttpClientConnectionOperator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClientConnectionOperator.class);
    static final DetachedSocketFactory PLAIN_SOCKET_FACTORY = socksProxy -> socksProxy == null ? new Socket() : new Socket(socksProxy);
    private final DetachedSocketFactory detachedSocketFactory;
    private final Lookup<TlsSocketStrategy> tlsSocketStrategyLookup;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    @Deprecated
    static Lookup<TlsSocketStrategy> adapt(Lookup<ConnectionSocketFactory> lookup) {
        return name -> {
            ConnectionSocketFactory sf = (ConnectionSocketFactory)lookup.lookup(name);
            return sf instanceof LayeredConnectionSocketFactory ? (socket, target, port, attachment, context) -> (SSLSocket)((LayeredConnectionSocketFactory)sf).createLayeredSocket(socket, target, port, attachment, context) : null;
        };
    }

    public DefaultHttpClientConnectionOperator(DetachedSocketFactory detachedSocketFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> tlsSocketStrategyLookup) {
        this.detachedSocketFactory = Args.notNull(detachedSocketFactory, "Plain socket factory");
        this.tlsSocketStrategyLookup = Args.notNull(tlsSocketStrategyLookup, "Socket factory registry");
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    @Deprecated
    public DefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, DefaultHttpClientConnectionOperator.adapt(socketFactoryRegistry));
    }

    public DefaultHttpClientConnectionOperator(SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> tlsSocketStrategyLookup) {
        this(PLAIN_SOCKET_FACTORY, schemePortResolver, dnsResolver, tlsSocketStrategyLookup);
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, TimeValue connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        Timeout timeout = connectTimeout != null ? Timeout.of(connectTimeout.getDuration(), connectTimeout.getTimeUnit()) : null;
        this.connect(conn, host, null, localAddress, timeout, socketConfig, null, context);
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, InetSocketAddress localAddress, Timeout connectTimeout, SocketConfig socketConfig, Object attachment, HttpContext context) throws IOException {
        InetAddress[] remoteAddresses;
        Args.notNull(conn, "Connection");
        Args.notNull(endpointHost, "Host");
        Args.notNull(socketConfig, "Socket config");
        Args.notNull(context, "Context");
        if (endpointHost.getAddress() != null) {
            remoteAddresses = new InetAddress[]{endpointHost.getAddress()};
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} resolving remote address", (Object)endpointHost.getHostName());
            }
            remoteAddresses = this.dnsResolver.resolve(endpointHost.getHostName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} resolved to {}", (Object)endpointHost.getHostName(), remoteAddresses == null ? "null" : Arrays.asList(remoteAddresses));
            }
            if (remoteAddresses == null || remoteAddresses.length == 0) {
                throw new UnknownHostException(endpointHost.getHostName());
            }
        }
        Timeout soTimeout = socketConfig.getSoTimeout();
        SocketAddress socksProxyAddress = socketConfig.getSocksProxyAddress();
        Proxy socksProxy = socksProxyAddress != null ? new Proxy(Proxy.Type.SOCKS, socksProxyAddress) : null;
        int port = this.schemePortResolver.resolve(endpointHost.getSchemeName(), endpointHost);
        for (int i = 0; i < remoteAddresses.length; ++i) {
            InetAddress address = remoteAddresses[i];
            boolean last = i == remoteAddresses.length - 1;
            InetSocketAddress remoteAddress = new InetSocketAddress(address, port);
            this.onBeforeSocketConnect(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connecting {}->{} ({})", endpointHost, localAddress, remoteAddress, connectTimeout);
            }
            Socket socket = this.detachedSocketFactory.create(socksProxy);
            try {
                TlsSocketStrategy tlsSocketStrategy;
                int linger;
                conn.bind(socket);
                if (soTimeout != null) {
                    socket.setSoTimeout(soTimeout.toMillisecondsIntBound());
                }
                socket.setReuseAddress(socketConfig.isSoReuseAddress());
                socket.setTcpNoDelay(socketConfig.isTcpNoDelay());
                socket.setKeepAlive(socketConfig.isSoKeepAlive());
                if (socketConfig.getRcvBufSize() > 0) {
                    socket.setReceiveBufferSize(socketConfig.getRcvBufSize());
                }
                if (socketConfig.getSndBufSize() > 0) {
                    socket.setSendBufferSize(socketConfig.getSndBufSize());
                }
                if ((linger = socketConfig.getSoLinger().toMillisecondsIntBound()) >= 0) {
                    socket.setSoLinger(true, linger);
                }
                if (localAddress != null) {
                    socket.bind(localAddress);
                }
                socket.connect(remoteAddress, TimeValue.isPositive(connectTimeout) ? connectTimeout.toMillisecondsIntBound() : 0);
                conn.bind(socket);
                this.onAfterSocketConnect(context, endpointHost);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {} connected {}->{}", ConnPoolSupport.getId(conn), endpointHost, conn.getLocalAddress(), conn.getRemoteAddress());
                }
                conn.setSocketTimeout(soTimeout);
                TlsSocketStrategy tlsSocketStrategy2 = tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? this.tlsSocketStrategyLookup.lookup(endpointHost.getSchemeName()) : null;
                if (tlsSocketStrategy != null) {
                    NamedEndpoint tlsName = endpointName != null ? endpointName : endpointHost;
                    this.onBeforeTlsHandshake(context, endpointHost);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} upgrading to TLS", (Object)ConnPoolSupport.getId(conn), (Object)tlsName);
                    }
                    SSLSocket sslSocket = tlsSocketStrategy.upgrade(socket, tlsName.getHostName(), tlsName.getPort(), attachment, context);
                    conn.bind(sslSocket, socket);
                    this.onAfterTlsHandshake(context, endpointHost);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {} upgraded to TLS", (Object)ConnPoolSupport.getId(conn), (Object)tlsName);
                    }
                }
                return;
            }
            catch (RuntimeException ex) {
                Closer.closeQuietly(socket);
                throw ex;
            }
            catch (IOException ex) {
                Closer.closeQuietly(socket);
                if (last) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connection to {} failed ({}); terminating operation", endpointHost, remoteAddress, ex.getClass());
                    }
                    throw ConnectExceptionSupport.enhance(ex, endpointHost, remoteAddresses);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} connection to {} failed ({}); retrying connection to the next address", endpointHost, remoteAddress, ex.getClass());
                continue;
            }
        }
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost host, HttpContext context) throws IOException {
        this.upgrade(conn, host, null, null, context);
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost endpointHost, NamedEndpoint endpointName, Object attachment, HttpContext context) throws IOException {
        TlsSocketStrategy tlsSocketStrategy;
        Socket socket = conn.getSocket();
        if (socket == null) {
            throw new ConnectionClosedException("Connection is closed");
        }
        String newProtocol = URIScheme.HTTP.same(endpointHost.getSchemeName()) ? URIScheme.HTTPS.id : endpointHost.getSchemeName();
        TlsSocketStrategy tlsSocketStrategy2 = tlsSocketStrategy = this.tlsSocketStrategyLookup != null ? this.tlsSocketStrategyLookup.lookup(newProtocol) : null;
        if (tlsSocketStrategy != null) {
            NamedEndpoint tlsName = endpointName != null ? endpointName : endpointHost;
            this.onBeforeTlsHandshake(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgrading to TLS {}:{}", ConnPoolSupport.getId(conn), tlsName.getHostName(), tlsName.getPort());
            }
            SSLSocket upgradedSocket = tlsSocketStrategy.upgrade(socket, tlsName.getHostName(), tlsName.getPort(), attachment, context);
            conn.bind(upgradedSocket);
            this.onAfterTlsHandshake(context, endpointHost);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} upgraded to TLS {}:{}", ConnPoolSupport.getId(conn), tlsName.getHostName(), tlsName.getPort());
            }
        } else {
            throw new UnsupportedSchemeException(newProtocol + " protocol is not supported");
        }
    }

    protected void onBeforeSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterSocketConnect(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onBeforeTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }

    protected void onAfterTlsHandshake(HttpContext httpContext, HttpHost endpointHost) {
    }
}

