/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.client.utils;

import java.time.Duration;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.arrow.driver.jdbc.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;

public final class FlightClientCache {
    @VisibleForTesting
    Cache<String, ClientCacheEntry> clientCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(600L)).build();

    public boolean isDud(String key) {
        return this.clientCache.getIfPresent(key) != null;
    }

    public void markLocationAsDud(String key) {
        this.clientCache.put(key, new ClientCacheEntry());
    }

    public void markLocationAsReachable(String key) {
        this.clientCache.invalidate(key);
    }

    public static final class ClientCacheEntry {
    }
}

