/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.binary;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VarBinaryVector;

public class ArrowFlightJdbcBinaryVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final ByteArrayGetter getter;

    public ArrowFlightJdbcBinaryVectorAccessor(FixedSizeBinaryVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this(vector::get, currentRowSupplier, setCursorWasNull);
    }

    public ArrowFlightJdbcBinaryVectorAccessor(VarBinaryVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this(vector::get, currentRowSupplier, setCursorWasNull);
    }

    public ArrowFlightJdbcBinaryVectorAccessor(LargeVarBinaryVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this(vector::get, currentRowSupplier, setCursorWasNull);
    }

    private ArrowFlightJdbcBinaryVectorAccessor(ByteArrayGetter getter, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = getter;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = this.getter.get(this.getCurrentRow());
        this.wasNull = bytes == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return bytes;
    }

    @Override
    public Object getObject() {
        return this.getBytes();
    }

    @Override
    public Class<?> getObjectClass() {
        return byte[].class;
    }

    @Override
    public String getString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public InputStream getAsciiStream() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream getUnicodeStream() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream getBinaryStream() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public Reader getCharacterStream() {
        String string = this.getString();
        if (string == null) {
            return null;
        }
        return new CharArrayReader(string.toCharArray());
    }

    private static interface ByteArrayGetter {
        public byte[] get(int var1);
    }
}

