/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Map;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcVectorSchemaRootResultSet;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.TransferPair;
import org.apache.arrow.driver.jdbc.utils.SqlTypes;

public class ArrowFlightJdbcArray
implements Array {
    private final FieldVector dataVector;
    private final long startOffset;
    private final long valuesCount;

    public ArrowFlightJdbcArray(FieldVector dataVector, long startOffset, long valuesCount) {
        this.dataVector = dataVector;
        this.startOffset = startOffset;
        this.valuesCount = valuesCount;
    }

    @Override
    public String getBaseTypeName() {
        ArrowType arrowType = this.dataVector.getField().getType();
        return SqlTypes.getSqlTypeNameFromArrowType(arrowType);
    }

    @Override
    public int getBaseType() {
        ArrowType arrowType = this.dataVector.getField().getType();
        return SqlTypes.getSqlTypeIdFromArrowType(arrowType);
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(null);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            throw new SQLFeatureNotSupportedException();
        }
        return ArrowFlightJdbcArray.getArrayNoBoundCheck(this.dataVector, this.startOffset, this.valuesCount);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(index, count, null);
    }

    private void checkBoundaries(long index, int count) {
        if (index < 0L || index + (long)count > this.startOffset + this.valuesCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static Object getArrayNoBoundCheck(ValueVector dataVector, long start, long count) {
        Object[] result = new Object[LargeMemoryUtil.checkedCastToInt(count)];
        int i = 0;
        while ((long)i < count) {
            result[i] = dataVector.getObject(LargeMemoryUtil.checkedCastToInt(start + (long)i));
            ++i;
        }
        return result;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            throw new SQLFeatureNotSupportedException();
        }
        this.checkBoundaries(index, count);
        return ArrowFlightJdbcArray.getArrayNoBoundCheck(this.dataVector, LargeMemoryUtil.checkedCastToInt(this.startOffset + index), count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(null);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            throw new SQLFeatureNotSupportedException();
        }
        return ArrowFlightJdbcArray.getResultSetNoBoundariesCheck(this.dataVector, this.startOffset, this.valuesCount);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSet(index, count, null);
    }

    private static ResultSet getResultSetNoBoundariesCheck(ValueVector dataVector, long start, long count) throws SQLException {
        TransferPair transferPair = dataVector.getTransferPair(dataVector.getAllocator());
        transferPair.splitAndTransfer(LargeMemoryUtil.checkedCastToInt(start), LargeMemoryUtil.checkedCastToInt(count));
        FieldVector vectorSlice = (FieldVector)transferPair.getTo();
        VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.of(vectorSlice);
        return ArrowFlightJdbcVectorSchemaRootResultSet.fromVectorSchemaRoot(vectorSchemaRoot);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            throw new SQLFeatureNotSupportedException();
        }
        this.checkBoundaries(index, count);
        return ArrowFlightJdbcArray.getResultSetNoBoundariesCheck(this.dataVector, LargeMemoryUtil.checkedCastToInt(this.startOffset + index), count);
    }

    @Override
    public void free() {
    }

    public String toString() {
        JsonStringArrayList<Object> array = new JsonStringArrayList<Object>((int)this.valuesCount);
        try {
            array.addAll(Arrays.asList((Object[])this.getArray()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return array.toString();
    }
}

