/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.compression;

import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.compression.CompressionUtil;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowBodyCompression;

public class NoCompressionCodec
implements CompressionCodec {
    public static final NoCompressionCodec INSTANCE = new NoCompressionCodec();
    public static final byte COMPRESSION_TYPE = -1;
    public static final ArrowBodyCompression DEFAULT_BODY_COMPRESSION = new ArrowBodyCompression(-1, 0);

    private NoCompressionCodec() {
    }

    @Override
    public ArrowBuf compress(BufferAllocator allocator, ArrowBuf uncompressedBuffer) {
        return uncompressedBuffer;
    }

    @Override
    public ArrowBuf decompress(BufferAllocator allocator, ArrowBuf compressedBuffer) {
        return compressedBuffer;
    }

    @Override
    public CompressionUtil.CodecType getCodecType() {
        return CompressionUtil.CodecType.NO_COMPRESSION;
    }

    public static class Factory
    implements CompressionCodec.Factory {
        public static final Factory INSTANCE = new Factory();

        @Override
        public CompressionCodec createCodec(CompressionUtil.CodecType codecType) {
            switch (codecType) {
                case NO_COMPRESSION: {
                    return INSTANCE;
                }
                case LZ4_FRAME: 
                case ZSTD: {
                    throw new IllegalArgumentException("Please add arrow-compression module to use CommonsCompressionFactory for " + String.valueOf((Object)codecType));
                }
            }
            throw new IllegalArgumentException("Unsupported codec type: " + String.valueOf((Object)codecType));
        }

        @Override
        public CompressionCodec createCodec(CompressionUtil.CodecType codecType, int compressionLevel) {
            return this.createCodec(codecType);
        }
    }
}

