/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.util.Map;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Action;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.ActionType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Criteria;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightStream;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.OutboundStreamListener;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.PollInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.PutResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Result;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Ticket;

public interface FlightProducer {
    public void getStream(CallContext var1, Ticket var2, ServerStreamListener var3);

    public void listFlights(CallContext var1, Criteria var2, StreamListener<FlightInfo> var3);

    public FlightInfo getFlightInfo(CallContext var1, FlightDescriptor var2);

    default public PollInfo pollFlightInfo(CallContext context, FlightDescriptor descriptor) {
        FlightInfo info = this.getFlightInfo(context, descriptor);
        return new PollInfo(info, null, null, null);
    }

    default public SchemaResult getSchema(CallContext context, FlightDescriptor descriptor) {
        FlightInfo info = this.getFlightInfo(context, descriptor);
        return new SchemaResult(info.getSchemaOptional().orElseThrow(() -> CallStatus.INVALID_ARGUMENT.withDescription("No schema is present in FlightInfo").toRuntimeException()));
    }

    public Runnable acceptPut(CallContext var1, FlightStream var2, StreamListener<PutResult> var3);

    default public void doExchange(CallContext context, FlightStream reader, ServerStreamListener writer) {
        throw CallStatus.UNIMPLEMENTED.withDescription("DoExchange is unimplemented").toRuntimeException();
    }

    public void doAction(CallContext var1, Action var2, StreamListener<Result> var3);

    public void listActions(CallContext var1, StreamListener<ActionType> var2);

    public static interface CallContext {
        public String peerIdentity();

        public boolean isCancelled();

        public <T extends FlightServerMiddleware> T getMiddleware(FlightServerMiddleware.Key<T> var1);

        public Map<FlightServerMiddleware.Key<?>, FlightServerMiddleware> getMiddleware();
    }

    public static interface StreamListener<T> {
        public void onNext(T var1);

        public void onError(Throwable var1);

        public void onCompleted();
    }

    public static interface ServerStreamListener
    extends OutboundStreamListener {
        public boolean isCancelled();

        public void setOnCancelHandler(Runnable var1);
    }
}

