/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.client.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightClient;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.BasicAuthCredentialWriter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.ClientIncomingAuthHeaderMiddleware;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.CredentialCallOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public final class ClientAuthenticationUtils {
    private ClientAuthenticationUtils() {
    }

    public static CredentialCallOption getAuthenticate(FlightClient client, CredentialCallOption credential, CallOption ... options) {
        ArrayList<CallOption> theseOptions = new ArrayList<CallOption>();
        theseOptions.add(credential);
        theseOptions.addAll(Arrays.asList(options));
        client.handshake(theseOptions.toArray(new CallOption[0]));
        return (CredentialCallOption)theseOptions.get(0);
    }

    public static CredentialCallOption getAuthenticate(FlightClient client, String username, String password, ClientIncomingAuthHeaderMiddleware.Factory factory, CallOption ... options) {
        return ClientAuthenticationUtils.getAuthenticate(client, new CredentialCallOption(new BasicAuthCredentialWriter(username, password)), factory, options);
    }

    private static CredentialCallOption getAuthenticate(FlightClient client, CredentialCallOption token, ClientIncomingAuthHeaderMiddleware.Factory factory, CallOption ... options) {
        ArrayList<CallOption> theseOptions = new ArrayList<CallOption>();
        theseOptions.add(token);
        theseOptions.addAll(Arrays.asList(options));
        client.handshake(theseOptions.toArray(new CallOption[0]));
        return factory.getCredentialCallOption();
    }

    @VisibleForTesting
    static KeyStore getKeyStoreInstance(String instance) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(instance);
        keyStore.load(null, null);
        return keyStore;
    }

    @VisibleForTesting
    static KeyStore getDefaultKeyStoreInstance(String password) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        try (InputStream fileInputStream = ClientAuthenticationUtils.getKeystoreInputStream();){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, password == null ? null : password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return ClientAuthenticationUtils.getOperatingSystem().contains("Windows");
    }

    public static boolean isMac() {
        return ClientAuthenticationUtils.getOperatingSystem().contains("Mac");
    }

    public static InputStream getCertificateInputStreamFromSystem(String password) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        ArrayList<KeyStore> keyStoreList = new ArrayList<KeyStore>();
        if (ClientAuthenticationUtils.isWindows()) {
            keyStoreList.add(ClientAuthenticationUtils.getKeyStoreInstance("Windows-ROOT"));
            keyStoreList.add(ClientAuthenticationUtils.getKeyStoreInstance("Windows-MY"));
        } else if (ClientAuthenticationUtils.isMac()) {
            keyStoreList.add(ClientAuthenticationUtils.getKeyStoreInstance("KeychainStore"));
            keyStoreList.add(ClientAuthenticationUtils.getDefaultKeyStoreInstance(password));
        } else {
            keyStoreList.add(ClientAuthenticationUtils.getDefaultKeyStoreInstance(password));
        }
        return ClientAuthenticationUtils.getCertificatesInputStream(keyStoreList);
    }

    @VisibleForTesting
    static InputStream getKeystoreInputStream() throws IOException {
        Path path = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        if (Files.notExists(path, new LinkOption[0])) {
            path = Paths.get(System.getProperty("java.home"), "jre", "lib", "security", "cacerts");
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    @VisibleForTesting
    static void getCertificatesInputStream(KeyStore keyStore, JcaPEMWriter pemWriter) throws IOException, KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            pemWriter.writeObject(keyStore.getCertificate(alias));
        }
        pemWriter.flush();
    }

    @VisibleForTesting
    static InputStream getCertificatesInputStream(Collection<KeyStore> keyStores) throws IOException, KeyStoreException {
        try (StringWriter writer = new StringWriter();){
            ByteArrayInputStream byteArrayInputStream;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter(writer);){
                for (KeyStore keyStore : keyStores) {
                    ClientAuthenticationUtils.getCertificatesInputStream(keyStore, pemWriter);
                }
                byteArrayInputStream = new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
            }
            return byteArrayInputStream;
        }
    }

    public static InputStream getCertificateStream(String keyStorePath, String keyStorePass) throws GeneralSecurityException, IOException {
        Preconditions.checkNotNull(keyStorePath, "KeyStore path cannot be null!");
        Preconditions.checkNotNull(keyStorePass, "KeyStorePass cannot be null!");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream keyStoreStream = Files.newInputStream(Paths.get(keyStorePath, new String[0]), new OpenOption[0]);){
            keyStore.load(keyStoreStream, keyStorePass.toCharArray());
        }
        return ClientAuthenticationUtils.getSingleCertificateInputStream(keyStore);
    }

    public static InputStream getTlsRootCertificatesStream(String tlsRootsCertificatesPath) throws GeneralSecurityException, IOException {
        Preconditions.checkNotNull(tlsRootsCertificatesPath, "TLS Root certificates path cannot be null!");
        return Files.newInputStream(Paths.get(tlsRootsCertificatesPath, new String[0]), new OpenOption[0]);
    }

    public static InputStream getClientCertificateStream(String clientCertificatePath) throws GeneralSecurityException, IOException {
        Preconditions.checkNotNull(clientCertificatePath, "Client certificate path cannot be null!");
        return Files.newInputStream(Paths.get(clientCertificatePath, new String[0]), new OpenOption[0]);
    }

    public static InputStream getClientKeyStream(String clientKeyPath) throws GeneralSecurityException, IOException {
        Preconditions.checkNotNull(clientKeyPath, "Client key path cannot be null!");
        return Files.newInputStream(Paths.get(clientKeyPath, new String[0]), new OpenOption[0]);
    }

    private static InputStream getSingleCertificateInputStream(KeyStore keyStore) throws KeyStoreException, IOException, CertificateException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            return ClientAuthenticationUtils.toInputStream(keyStore.getCertificate(alias));
        }
        throw new CertificateException("Keystore did not have a certificate.");
    }

    private static InputStream toInputStream(Certificate certificate) throws IOException {
        try (StringWriter writer = new StringWriter();){
            ByteArrayInputStream byteArrayInputStream;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter(writer);){
                pemWriter.writeObject(certificate);
                pemWriter.flush();
                byteArrayInputStream = new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
            }
            return byteArrayInputStream;
        }
    }
}

