/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its;

import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Choice;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Object;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DEROctetString;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.EccCurvePoint;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.EccP256CurvePoint;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.EccP384CurvePoint;

public class PublicVerificationKey
extends ASN1Object
implements ASN1Choice {
    public static final int ecdsaNistP256 = 0;
    public static final int ecdsaBrainpoolP256r1 = 1;
    public static final int extension = 2;
    public static final int ecdsaBrainpoolP384r1 = 3;
    final int choice;
    final ASN1Encodable curvePoint;

    public PublicVerificationKey(int n, ASN1Encodable aSN1Encodable) {
        this.choice = n;
        this.curvePoint = aSN1Encodable;
    }

    public static PublicVerificationKey getInstance(Object object) {
        ASN1Object aSN1Object;
        if (object instanceof PublicVerificationKey) {
            return (PublicVerificationKey)object;
        }
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object);
        switch (aSN1TaggedObject.getTagNo()) {
            case 0: 
            case 1: {
                aSN1Object = EccP256CurvePoint.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 2: {
                aSN1Object = DEROctetString.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 3: {
                aSN1Object = EccP384CurvePoint.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag value " + aSN1TaggedObject.getTagNo());
            }
        }
        return new PublicVerificationKey(aSN1TaggedObject.getTagNo(), aSN1Object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getCurvePoint() {
        return this.curvePoint;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.curvePoint);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable curvePoint;

        public Builder setChoice(int n) {
            this.choice = n;
            return this;
        }

        public Builder setCurvePoint(EccCurvePoint eccCurvePoint) {
            this.curvePoint = eccCurvePoint;
            return this;
        }

        public Builder ecdsaNistP256(EccP256CurvePoint eccP256CurvePoint) {
            this.curvePoint = eccP256CurvePoint;
            return this;
        }

        public Builder ecdsaBrainpoolP256r1(EccP256CurvePoint eccP256CurvePoint) {
            this.curvePoint = eccP256CurvePoint;
            return this;
        }

        public Builder ecdsaBrainpoolP384r1(EccP384CurvePoint eccP384CurvePoint) {
            this.curvePoint = eccP384CurvePoint;
            return this;
        }

        public Builder extension(byte[] byArray) {
            this.curvePoint = new DEROctetString(byArray);
            return this;
        }

        public PublicVerificationKey createPublicVerificationKey() {
            return new PublicVerificationKey(this.choice, this.curvePoint);
        }
    }
}

