/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.its.ITSPublicEncryptionKey;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.its.ITSValidityPeriod;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.its.operator.ECDSAEncoder;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.its.operator.ITSContentVerifierProvider;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.OEREncoder;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.Certificate;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.IssuerIdentifier;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.PublicEncryptionKey;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.Signature;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.template.IEEE1609dot2;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.operator.ContentVerifier;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.util.Encodable;

public class ITSCertificate
implements Encodable {
    private final Certificate certificate;

    public ITSCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public IssuerIdentifier getIssuer() {
        return this.certificate.getCertificateBase().getIssuer();
    }

    public ITSValidityPeriod getValidityPeriod() {
        return new ITSValidityPeriod(this.certificate.getCertificateBase().getToBeSignedCertificate().getValidityPeriod());
    }

    public ITSPublicEncryptionKey getPublicEncryptionKey() {
        PublicEncryptionKey publicEncryptionKey = this.certificate.getCertificateBase().getToBeSignedCertificate().getEncryptionKey();
        if (publicEncryptionKey != null) {
            return new ITSPublicEncryptionKey(publicEncryptionKey);
        }
        return null;
    }

    public boolean isSignatureValid(ITSContentVerifierProvider iTSContentVerifierProvider) throws Exception {
        ContentVerifier contentVerifier = iTSContentVerifierProvider.get(this.certificate.getCertificateBase().getSignature().getChoice());
        OutputStream outputStream = contentVerifier.getOutputStream();
        outputStream.write(OEREncoder.toByteArray(this.certificate.getCertificateBase().getToBeSignedCertificate(), IEEE1609dot2.tbsCertificate));
        outputStream.close();
        Signature signature = this.certificate.getCertificateBase().getSignature();
        return contentVerifier.verify(ECDSAEncoder.toX962(signature));
    }

    public Certificate toASN1Structure() {
        return this.certificate;
    }

    public byte[] getEncoded() throws IOException {
        return OEREncoder.toByteArray(this.certificate.getCertificateBase(), IEEE1609dot2.certificate);
    }
}

