/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.BindableService;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.CallOptions;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ClientCall;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ConnectivityState;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ManagedChannel;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.MethodDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightClient;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;

public class FlightGrpcUtils {
    private FlightGrpcUtils() {
    }

    public static BindableService createFlightService(BufferAllocator allocator, FlightProducer producer, ServerAuthHandler authHandler, ExecutorService executor) {
        return new FlightBindingService(allocator, producer, authHandler, executor);
    }

    public static FlightClient createFlightClient(BufferAllocator incomingAllocator, ManagedChannel channel) {
        return new FlightClient(incomingAllocator, channel, Collections.emptyList());
    }

    public static FlightClient createFlightClientWithSharedChannel(BufferAllocator incomingAllocator, ManagedChannel channel) {
        return new FlightClient(incomingAllocator, new NonClosingProxyManagedChannel(channel), Collections.emptyList());
    }

    @VisibleForTesting
    static class NonClosingProxyManagedChannel
    extends ManagedChannel {
        private final ManagedChannel channel;
        private boolean isShutdown;

        NonClosingProxyManagedChannel(ManagedChannel channel) {
            this.channel = channel;
            this.isShutdown = channel.isShutdown();
        }

        @Override
        public ManagedChannel shutdown() {
            this.isShutdown = true;
            return this;
        }

        @Override
        public boolean isShutdown() {
            if (this.channel.isShutdown()) {
                this.shutdown();
            }
            return this.isShutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown();
        }

        @Override
        public ManagedChannel shutdownNow() {
            return this.shutdown();
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) {
            return this.isShutdown();
        }

        @Override
        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            if (this.isShutdown()) {
                throw new IllegalStateException("Channel has been shut down.");
            }
            return this.channel.newCall(methodDescriptor, callOptions);
        }

        @Override
        public String authority() {
            return this.channel.authority();
        }

        @Override
        public ConnectivityState getState(boolean requestConnection) {
            if (this.isShutdown()) {
                return ConnectivityState.SHUTDOWN;
            }
            return this.channel.getState(requestConnection);
        }

        @Override
        public void notifyWhenStateChanged(ConnectivityState source, Runnable callback) {
            this.channel.notifyWhenStateChanged(source, callback);
        }

        @Override
        public void resetConnectBackoff() {
            this.channel.resetConnectBackoff();
        }

        @Override
        public void enterIdle() {
            this.channel.enterIdle();
        }
    }
}

