/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.base.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.collect.Iterables;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.collect.Multimap;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallHeaders;

public class FlightCallHeaders
implements CallHeaders {
    private final Multimap<String, Object> keysAndValues = ArrayListMultimap.create();

    @Override
    public String get(String key) {
        Collection<Object> values = this.keysAndValues.get(key);
        if (values.isEmpty()) {
            return null;
        }
        if (key.endsWith("-bin")) {
            return new String((byte[])Iterables.get(values, 0), StandardCharsets.UTF_8);
        }
        return (String)Iterables.get(values, 0);
    }

    @Override
    public byte[] getByte(String key) {
        Collection<Object> values = this.keysAndValues.get(key);
        if (values.isEmpty()) {
            return null;
        }
        if (key.endsWith("-bin")) {
            return (byte[])Iterables.get(values, 0);
        }
        return ((String)Iterables.get(values, 0)).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Iterable<String> getAll(String key) {
        if (key.endsWith("-bin")) {
            return this.keysAndValues.get(key).stream().map(o -> new String((byte[])o, StandardCharsets.UTF_8)).collect(Collectors.toList());
        }
        return this.keysAndValues.get(key);
    }

    @Override
    public Iterable<byte[]> getAllByte(String key) {
        if (key.endsWith("-bin")) {
            return this.keysAndValues.get(key);
        }
        return this.keysAndValues.get(key).stream().map(o -> ((String)o).getBytes(StandardCharsets.UTF_8)).collect(Collectors.toList());
    }

    @Override
    public void insert(String key, String value) {
        this.keysAndValues.put(key, value);
    }

    @Override
    public void insert(String key, byte[] value) {
        Preconditions.checkArgument(key.endsWith("-bin"), "Binary header is named %s. It must end with %s", (Object)key, (Object)"-bin");
        Preconditions.checkArgument(key.length() > "-bin".length(), "empty key name");
        this.keysAndValues.put(key, value);
    }

    @Override
    public Set<String> keys() {
        return this.keysAndValues.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.keysAndValues.containsKey(key);
    }

    public String toString() {
        return this.keysAndValues.toString();
    }
}

