/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.AbstractByteBuf;
import org.apache.arrow.driver.jdbc.shaded.io.netty.buffer.ByteBuf;
import org.apache.arrow.driver.jdbc.shaded.io.netty.util.internal.PlatformDependent;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BoundsChecking;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.patch.ArrowByteBufAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;

public class NettyArrowBuf
extends AbstractByteBuf
implements AutoCloseable {
    private final ArrowBuf arrowBuf;
    private final ArrowByteBufAllocator arrowByteBufAllocator;
    private int length;
    private final long address;

    public NettyArrowBuf(ArrowBuf arrowBuf, BufferAllocator bufferAllocator, int length) {
        super(length);
        this.arrowBuf = arrowBuf;
        this.arrowByteBufAllocator = new ArrowByteBufAllocator(bufferAllocator);
        this.length = length;
        this.address = arrowBuf.memoryAddress();
    }

    @Override
    public ByteBuf copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf retain() {
        this.arrowBuf.getReferenceManager().retain();
        return this;
    }

    public ArrowBuf arrowBuf() {
        return this.arrowBuf;
    }

    @Override
    public ByteBuf retain(int increment) {
        this.arrowBuf.getReferenceManager().retain(increment);
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public synchronized ByteBuf capacity(int newCapacity) {
        if (newCapacity == this.length) {
            return this;
        }
        Preconditions.checkArgument(newCapacity >= 0);
        if (newCapacity < this.length) {
            this.length = newCapacity;
            return this;
        }
        throw new UnsupportedOperationException("Buffers don't support resizing that increases the size.");
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public int refCnt() {
        return this.arrowBuf.getReferenceManager().getRefCount();
    }

    @Override
    public ArrowByteBufAllocator alloc() {
        return this.arrowByteBufAllocator;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("Operation not supported on direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("Operation not supported on direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.address;
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object hint) {
        return this;
    }

    @Override
    public int capacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.arrowBuf.capacity());
    }

    @Override
    public NettyArrowBuf slice() {
        return NettyArrowBuf.unwrapBuffer(this.arrowBuf.slice(this.readerIndex, this.writerIndex - this.readerIndex));
    }

    @Override
    public NettyArrowBuf slice(int index, int length) {
        return NettyArrowBuf.unwrapBuffer(this.arrowBuf.slice(index, length));
    }

    @Override
    public void close() {
        this.arrowBuf.close();
    }

    @Override
    public boolean release() {
        return this.arrowBuf.getReferenceManager().release();
    }

    @Override
    public boolean release(int decrement) {
        return this.arrowBuf.getReferenceManager().release(decrement);
    }

    @Override
    public NettyArrowBuf readerIndex(int readerIndex) {
        super.readerIndex(readerIndex);
        return this;
    }

    @Override
    public NettyArrowBuf writerIndex(int writerIndex) {
        super.writerIndex(writerIndex);
        return this;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        ByteBuffer nioBuf = this.getDirectBuffer(index);
        return (ByteBuffer)nioBuf.clear().limit(length);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{this.nioBuffer()};
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.chk(index, length);
        ByteBuffer buffer = this.getDirectBuffer(index);
        buffer.limit(length);
        return buffer;
    }

    public ByteBuffer nioBuffer(long index, int length) {
        this.chk(index, length);
        ByteBuffer buffer = this.getDirectBuffer(index);
        buffer.limit(length);
        return buffer;
    }

    private ByteBuffer getDirectBuffer(long index) {
        return PlatformDependent.directBuffer(this.addr(index), LargeMemoryUtil.checkedCastToInt((long)this.length - index));
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.arrowBuf.getBytes((long)index, dst);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.arrowBuf.setBytes((long)index, src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.arrowBuf.getBytes((long)index, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.arrowBuf.setBytes((long)index, src, srcIndex, (long)length);
        return this;
    }

    private static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.chk(index, length);
        Preconditions.checkArgument(dst != null, "Expecting valid dst ByteBuffer");
        if (NettyArrowBuf.isOutOfBounds(dstIndex, length, dst.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex + " length: " + length);
        }
        long srcAddress = this.addr(index);
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstIndex;
            PlatformDependent.copyMemory(srcAddress, dstAddress, length);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory(srcAddress, dst.array(), dstIndex += dst.arrayOffset(), (long)length);
        } else {
            dst.setBytes(dstIndex, this, index, length);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.chk(index, length);
        Preconditions.checkArgument(src != null, "Expecting valid src ByteBuffer");
        if (NettyArrowBuf.isOutOfBounds(srcIndex, length, src.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + srcIndex + " length: " + length);
        }
        if (length != 0) {
            long dstAddress = this.addr(index);
            if (src.hasMemoryAddress()) {
                long srcAddress = src.memoryAddress() + (long)srcIndex;
                PlatformDependent.copyMemory(srcAddress, dstAddress, length);
            } else if (src.hasArray()) {
                PlatformDependent.copyMemory(src.array(), srcIndex += src.arrayOffset(), dstAddress, (long)length);
            } else {
                src.getBytes(srcIndex, this, index, length);
            }
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.arrowBuf.getBytes(index, out, length);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.arrowBuf.setBytes(index, in, length);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        Preconditions.checkArgument(out != null, "expecting valid gathering byte channel");
        this.chk(index, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.getDirectBuffer(index);
        tmpBuf.clear().limit(length);
        return out.write(tmpBuf);
    }

    @Override
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        this.chk(index, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.getDirectBuffer(index);
        tmpBuf.clear().limit(length);
        return out.write(tmpBuf, position);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return (int)in.read(this.nioBuffers(index, length));
    }

    @Override
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return (int)in.read(this.nioBuffers(index, length));
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return this.getUnsignedMedium(index);
    }

    @Override
    protected int _getUnsignedMediumLE(int index) {
        this.chk(index, 3L);
        long addr = this.addr(index);
        return PlatformDependent.getByte(addr) & 0xFF | (Short.reverseBytes(PlatformDependent.getShort(addr + 1L)) & 0xFFFF) << 8;
    }

    @Override
    protected byte _getByte(int index) {
        return this.getByte(index);
    }

    @Override
    public byte getByte(int index) {
        return this.arrowBuf.getByte(index);
    }

    @Override
    protected short _getShortLE(int index) {
        short s = this.getShort(index);
        return Short.reverseBytes(s);
    }

    @Override
    protected short _getShort(int index) {
        return this.getShort(index);
    }

    @Override
    public short getShort(int index) {
        return this.arrowBuf.getShort(index);
    }

    @Override
    protected int _getIntLE(int index) {
        int value = this.getInt(index);
        return Integer.reverseBytes(value);
    }

    @Override
    protected int _getInt(int index) {
        return this.getInt(index);
    }

    @Override
    public int getInt(int index) {
        return this.arrowBuf.getInt(index);
    }

    @Override
    protected long _getLongLE(int index) {
        long value = this.getLong(index);
        return Long.reverseBytes(value);
    }

    @Override
    protected long _getLong(int index) {
        return this.getLong(index);
    }

    @Override
    public long getLong(int index) {
        return this.arrowBuf.getLong(index);
    }

    @Override
    protected void _setByte(int index, int value) {
        this.setByte(index, value);
    }

    @Override
    public NettyArrowBuf setByte(int index, int value) {
        this.arrowBuf.setByte((long)index, value);
        return this;
    }

    @Override
    protected void _setShortLE(int index, int value) {
        this.chk(index, 2L);
        PlatformDependent.putShort(this.addr(index), Short.reverseBytes((short)value));
    }

    @Override
    protected void _setShort(int index, int value) {
        this.setShort(index, value);
    }

    @Override
    public NettyArrowBuf setShort(int index, int value) {
        this.arrowBuf.setShort((long)index, value);
        return this;
    }

    private long addr(long index) {
        return this.address + index;
    }

    private void chk(long index, long fieldLength) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.ensureAccessible();
            if (fieldLength < 0L) {
                throw new IllegalArgumentException("length: " + fieldLength + " (expected: >= 0)");
            }
            if (index < 0L || index > (long)this.capacity() - fieldLength) {
                throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
            }
        }
    }

    @Override
    protected void _setMedium(int index, int value) {
        this.setMedium(index, value);
    }

    @Override
    protected void _setMediumLE(int index, int value) {
        this.chk(index, 3L);
        long addr = this.addr(index);
        PlatformDependent.putByte(addr, (byte)value);
        PlatformDependent.putShort(addr + 1L, Short.reverseBytes((short)(value >>> 8)));
    }

    @Override
    public NettyArrowBuf setMedium(int index, int value) {
        this.chk(index, 3L);
        long addr = this.addr(index);
        PlatformDependent.putShort(addr, (short)value);
        PlatformDependent.putByte(addr + 2L, (byte)(value >>> 16));
        return this;
    }

    @Override
    @VisibleForTesting
    protected void _setInt(int index, int value) {
        this.setInt(index, value);
    }

    @Override
    @VisibleForTesting
    protected void _setIntLE(int index, int value) {
        this.chk(index, 4L);
        PlatformDependent.putInt(this.addr(index), Integer.reverseBytes(value));
    }

    @Override
    public NettyArrowBuf setInt(int index, int value) {
        this.arrowBuf.setInt(index, value);
        return this;
    }

    @Override
    protected void _setLong(int index, long value) {
        this.setLong(index, value);
    }

    @Override
    public void _setLongLE(int index, long value) {
        this.chk(index, 8L);
        PlatformDependent.putLong(this.addr(index), Long.reverseBytes(value));
    }

    @Override
    public NettyArrowBuf setLong(int index, long value) {
        this.arrowBuf.setLong(index, value);
        return this;
    }

    public static NettyArrowBuf unwrapBuffer(ArrowBuf buf) {
        NettyArrowBuf nettyArrowBuf = new NettyArrowBuf(buf, buf.getReferenceManager().getAllocator(), LargeMemoryUtil.checkedCastToInt(buf.capacity()));
        nettyArrowBuf.readerIndex(LargeMemoryUtil.checkedCastToInt(buf.readerIndex()));
        nettyArrowBuf.writerIndex(LargeMemoryUtil.checkedCastToInt(buf.writerIndex()));
        return nettyArrowBuf;
    }
}

