/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.util.Map;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.integration.tests.FlightSqlScenario;
import org.apache.arrow.flight.integration.tests.FlightSqlScenarioProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.sql.CancelResult;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSqlExtensionScenario
extends FlightSqlScenario {
    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        try (FlightSqlClient sqlClient = new FlightSqlClient(client);){
            this.validateMetadataRetrieval(sqlClient);
            this.validateStatementExecution(sqlClient);
            this.validatePreparedStatementExecution(allocator, sqlClient);
            this.validateTransactions(allocator, sqlClient);
        }
    }

    private void validateMetadataRetrieval(FlightSqlClient sqlClient) throws Exception {
        this.validate(FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, sqlClient.getSqlInfo(new FlightSql.SqlInfo[0]), sqlClient, s -> {
            Map<Integer, Object> infoValues = this.readSqlInfoStream((FlightStream)s);
            IntegrationAssertions.assertEquals(Boolean.FALSE, infoValues.get(4));
            IntegrationAssertions.assertEquals(Boolean.TRUE, infoValues.get(5));
            IntegrationAssertions.assertEquals("min_version", infoValues.get(6));
            IntegrationAssertions.assertEquals("max_version", infoValues.get(7));
            IntegrationAssertions.assertEquals(2, infoValues.get(8));
            IntegrationAssertions.assertEquals(Boolean.TRUE, infoValues.get(9));
            IntegrationAssertions.assertEquals(42, infoValues.get(100));
            IntegrationAssertions.assertEquals(7, infoValues.get(101));
        });
    }

    private void validateStatementExecution(FlightSqlClient sqlClient) throws Exception {
        FlightInfo info = sqlClient.executeSubstrait(SUBSTRAIT_PLAN, new CallOption[0]);
        this.validate(FlightSqlScenarioProducer.getQuerySchema(), info, sqlClient);
        SchemaResult result = sqlClient.getExecuteSubstraitSchema(SUBSTRAIT_PLAN, new CallOption[0]);
        this.validateSchema(FlightSqlScenarioProducer.getQuerySchema(), result);
        IntegrationAssertions.assertEquals(CancelResult.CANCELLED, sqlClient.cancelQuery(info, new CallOption[0]));
        IntegrationAssertions.assertEquals(sqlClient.executeSubstraitUpdate(SUBSTRAIT_PLAN, new CallOption[0]), 10000L);
    }

    private void validatePreparedStatementExecution(BufferAllocator allocator, FlightSqlClient sqlClient) throws Exception {
        try (FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare(SUBSTRAIT_PLAN, new CallOption[0]);
             VectorSchemaRoot parameters = VectorSchemaRoot.create((Schema)FlightSqlScenarioProducer.getQuerySchema(), (BufferAllocator)allocator);){
            parameters.setRowCount(1);
            preparedStatement.setParameters(parameters);
            this.validate(FlightSqlScenarioProducer.getQuerySchema(), preparedStatement.execute(new CallOption[0]), sqlClient);
            this.validateSchema(FlightSqlScenarioProducer.getQuerySchema(), preparedStatement.fetchSchema(new CallOption[0]));
        }
        preparedStatement = sqlClient.prepare(SUBSTRAIT_PLAN, new CallOption[0]);
        try {
            IntegrationAssertions.assertEquals(preparedStatement.executeUpdate(new CallOption[0]), 20000L);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private void validateTransactions(BufferAllocator allocator, FlightSqlClient sqlClient) throws Exception {
        VectorSchemaRoot parameters;
        FlightSqlClient.Transaction transaction = sqlClient.beginTransaction(new CallOption[0]);
        IntegrationAssertions.assertEquals(TRANSACTION_ID, transaction.getTransactionId());
        FlightSqlClient.Savepoint savepoint = sqlClient.beginSavepoint(transaction, "savepoint_name", new CallOption[0]);
        IntegrationAssertions.assertEquals(SAVEPOINT_ID, savepoint.getSavepointId());
        FlightInfo info = sqlClient.execute("SELECT STATEMENT", transaction, new CallOption[0]);
        this.validate(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), info, sqlClient);
        info = sqlClient.executeSubstrait(SUBSTRAIT_PLAN, transaction, new CallOption[0]);
        this.validate(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), info, sqlClient);
        SchemaResult schema = sqlClient.getExecuteSchema("SELECT STATEMENT", transaction, new CallOption[0]);
        this.validateSchema(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), schema);
        schema = sqlClient.getExecuteSubstraitSchema(SUBSTRAIT_PLAN, transaction, new CallOption[0]);
        this.validateSchema(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), schema);
        IntegrationAssertions.assertEquals(sqlClient.executeUpdate("UPDATE STATEMENT", transaction, new CallOption[0]), 15000L);
        IntegrationAssertions.assertEquals(sqlClient.executeSubstraitUpdate(SUBSTRAIT_PLAN, transaction, new CallOption[0]), 15000L);
        try (FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare("SELECT PREPARED STATEMENT", transaction, new CallOption[0]);){
            parameters = VectorSchemaRoot.create((Schema)FlightSqlScenarioProducer.getQuerySchema(), (BufferAllocator)allocator);
            try {
                parameters.setRowCount(1);
                preparedStatement.setParameters(parameters);
                this.validate(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), preparedStatement.execute(new CallOption[0]), sqlClient);
                schema = preparedStatement.fetchSchema(new CallOption[0]);
                this.validateSchema(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), schema);
            }
            finally {
                if (parameters != null) {
                    parameters.close();
                }
            }
        }
        preparedStatement = sqlClient.prepare(SUBSTRAIT_PLAN, transaction, new CallOption[0]);
        try {
            parameters = VectorSchemaRoot.create((Schema)FlightSqlScenarioProducer.getQuerySchema(), (BufferAllocator)allocator);
            try {
                parameters.setRowCount(1);
                preparedStatement.setParameters(parameters);
                this.validate(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), preparedStatement.execute(new CallOption[0]), sqlClient);
                schema = preparedStatement.fetchSchema(new CallOption[0]);
                this.validateSchema(FlightSqlScenarioProducer.getQueryWithTransactionSchema(), schema);
            }
            finally {
                if (parameters != null) {
                    parameters.close();
                }
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        preparedStatement = sqlClient.prepare("UPDATE PREPARED STATEMENT", transaction, new CallOption[0]);
        try {
            IntegrationAssertions.assertEquals(preparedStatement.executeUpdate(new CallOption[0]), 25000L);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        preparedStatement = sqlClient.prepare(SUBSTRAIT_PLAN, transaction, new CallOption[0]);
        try {
            IntegrationAssertions.assertEquals(preparedStatement.executeUpdate(new CallOption[0]), 25000L);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        sqlClient.rollback(savepoint, new CallOption[0]);
        FlightSqlClient.Savepoint savepoint2 = sqlClient.beginSavepoint(transaction, "savepoint_name", new CallOption[0]);
        IntegrationAssertions.assertEquals(SAVEPOINT_ID, savepoint2.getSavepointId());
        sqlClient.release(savepoint, new CallOption[0]);
        sqlClient.commit(transaction, new CallOption[0]);
        FlightSqlClient.Transaction transaction2 = sqlClient.beginTransaction(new CallOption[0]);
        IntegrationAssertions.assertEquals(TRANSACTION_ID, transaction2.getTransactionId());
        sqlClient.rollback(transaction, new CallOption[0]);
    }
}

