/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class OrderedScenario
implements Scenario {
    private static final Schema SCHEMA = new Schema(Collections.singletonList(Field.notNullable((String)"number", (ArrowType)Types.MinorType.INT.getType())));
    private static final byte[] ORDERED_COMMAND = "ordered".getBytes(StandardCharsets.UTF_8);

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new OrderedProducer(allocator);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) throws Exception {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        FlightInfo info = client.getInfo(FlightDescriptor.command((byte[])ORDERED_COMMAND), new CallOption[0]);
        IntegrationAssertions.assertTrue("ordered must be true", info.getOrdered());
        IntegrationAssertions.assertEquals(3, info.getEndpoints().size());
        int offset = 0;
        for (int multiplier : Arrays.asList(1, 10, 100)) {
            FlightEndpoint endpoint = (FlightEndpoint)info.getEndpoints().get(offset);
            IntegrationAssertions.assertTrue("locations must be empty", endpoint.getLocations().isEmpty());
            try (FlightStream stream = client.getStream(endpoint.getTicket(), new CallOption[0]);){
                IntegrationAssertions.assertEquals(SCHEMA, stream.getSchema());
                IntegrationAssertions.assertTrue("stream must have a batch", stream.next());
                IntVector number = (IntVector)stream.getRoot().getVector(0);
                IntegrationAssertions.assertEquals(3, stream.getRoot().getRowCount());
                IntegrationAssertions.assertFalse("value must be non-null", number.isNull(0));
                IntegrationAssertions.assertFalse("value must be non-null", number.isNull(1));
                IntegrationAssertions.assertFalse("value must be non-null", number.isNull(2));
                IntegrationAssertions.assertEquals(multiplier, number.get(0));
                IntegrationAssertions.assertEquals(2 * multiplier, number.get(1));
                IntegrationAssertions.assertEquals(3 * multiplier, number.get(2));
                IntegrationAssertions.assertFalse("stream must have one batch", stream.next());
            }
            ++offset;
        }
    }

    private static class OrderedProducer
    extends NoOpFlightProducer {
        private static final byte[] TICKET_1 = "1".getBytes(StandardCharsets.UTF_8);
        private static final byte[] TICKET_2 = "2".getBytes(StandardCharsets.UTF_8);
        private static final byte[] TICKET_3 = "3".getBytes(StandardCharsets.UTF_8);
        private final BufferAllocator allocator;

        OrderedProducer(BufferAllocator allocator) {
            this.allocator = Objects.requireNonNull(allocator);
        }

        public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)SCHEMA, (BufferAllocator)this.allocator);){
                IntVector number = (IntVector)root.getVector(0);
                if (Arrays.equals(ticket.getBytes(), TICKET_1)) {
                    number.setSafe(0, 1);
                    number.setSafe(1, 2);
                    number.setSafe(2, 3);
                } else if (Arrays.equals(ticket.getBytes(), TICKET_2)) {
                    number.setSafe(0, 10);
                    number.setSafe(1, 20);
                    number.setSafe(2, 30);
                } else if (Arrays.equals(ticket.getBytes(), TICKET_3)) {
                    number.setSafe(0, 100);
                    number.setSafe(1, 200);
                    number.setSafe(2, 300);
                } else {
                    listener.error((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Could not find flight: " + new String(ticket.getBytes(), StandardCharsets.UTF_8)).toRuntimeException());
                    return;
                }
                root.setRowCount(3);
                listener.start(root);
                listener.putNext();
                listener.completed();
            }
        }

        public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
            boolean ordered = descriptor.isCommand() && Arrays.equals(descriptor.getCommand(), ORDERED_COMMAND);
            List<FlightEndpoint> endpoints = ordered ? Arrays.asList(new FlightEndpoint(new Ticket(TICKET_1), new Location[0]), new FlightEndpoint(new Ticket(TICKET_2), new Location[0]), new FlightEndpoint(new Ticket(TICKET_3), new Location[0])) : Arrays.asList(new FlightEndpoint(new Ticket(TICKET_1), new Location[0]), new FlightEndpoint(new Ticket(TICKET_3), new Location[0]), new FlightEndpoint(new Ticket(TICKET_2), new Location[0]));
            return new FlightInfo(SCHEMA, descriptor, endpoints, -1L, -1L, ordered, IpcOption.DEFAULT);
        }
    }
}

