/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.RenewFlightEndpointRequest;
import org.apache.arrow.flight.integration.tests.ExpirationTimeProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;

final class ExpirationTimeRenewFlightEndpointScenario
implements Scenario {
    ExpirationTimeRenewFlightEndpointScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new ExpirationTimeProducer(allocator);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        FlightInfo info = client.getInfo(FlightDescriptor.command((byte[])"expiration".getBytes(StandardCharsets.UTF_8)), new CallOption[0]);
        for (FlightEndpoint endpoint : info.getEndpoints()) {
            if (!endpoint.getExpirationTime().isPresent()) continue;
            Instant expiration = (Instant)endpoint.getExpirationTime().get();
            FlightEndpoint renewed = client.renewFlightEndpoint(new RenewFlightEndpointRequest(endpoint), new CallOption[0]);
            IntegrationAssertions.assertTrue("Renewed FlightEndpoint must have expiration time", renewed.getExpirationTime().isPresent());
            IntegrationAssertions.assertTrue("Renewed FlightEndpoint must have newer expiration time", ((Instant)renewed.getExpirationTime().get()).isAfter(expiration));
        }
    }
}

