/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.arrow.flight.AsyncPutListener;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.Scenarios;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegrationTestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestClient.class);
    private final Options options = new Options();

    private IntegrationTestClient() {
        this.options.addOption("j", "json", true, "json file");
        this.options.addOption("scenario", true, "The integration test scenario.");
        this.options.addOption("host", true, "The host to connect to.");
        this.options.addOption("port", true, "The port to connect to.");
    }

    public static void main(String[] args) {
        try {
            new IntegrationTestClient().run(args);
        }
        catch (ParseException e) {
            IntegrationTestClient.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            IntegrationTestClient.fatalError("Error accessing files", e);
        }
        catch (Exception e) {
            IntegrationTestClient.fatalError("Unknown error", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private void run(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        String host = cmd.getOptionValue("host", "localhost");
        int port = Integer.parseInt(cmd.getOptionValue("port", "31337"));
        Location defaultLocation = Location.forGrpcInsecure((String)host, (int)port);
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)defaultLocation).build();){
            if (cmd.hasOption("scenario")) {
                Scenarios.getScenario(cmd.getOptionValue("scenario")).client((BufferAllocator)allocator, defaultLocation, client);
            } else {
                String inputPath = cmd.getOptionValue("j");
                IntegrationTestClient.testStream((BufferAllocator)allocator, client, inputPath);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void testStream(BufferAllocator allocator, FlightClient client, String inputPath) throws IOException {
        FlightDescriptor descriptor = FlightDescriptor.path((String[])new String[]{inputPath});
        try (JsonFileReader reader = new JsonFileReader(new File(inputPath), allocator);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)reader.start(), (BufferAllocator)allocator);){
            FlightClient.ClientStreamListener stream = client.startPut(descriptor, root, (DictionaryProvider)reader, (FlightClient.PutListener)new AsyncPutListener(){
                int counter = 0;

                public void onNext(PutResult val) {
                    byte[] metadataRaw = new byte[LargeMemoryUtil.checkedCastToInt((long)val.getApplicationMetadata().readableBytes())];
                    val.getApplicationMetadata().readBytes(metadataRaw);
                    String metadata = new String(metadataRaw, StandardCharsets.UTF_8);
                    if (!Integer.toString(this.counter).equals(metadata)) {
                        throw new RuntimeException(String.format("Invalid ACK from server. Expected '%d' but got '%s'.", this.counter, metadata));
                    }
                    ++this.counter;
                }
            }, new CallOption[0]);
            int counter = 0;
            while (reader.read(root)) {
                byte[] rawMetadata = Integer.toString(counter).getBytes(StandardCharsets.UTF_8);
                ArrowBuf metadata = allocator.buffer((long)rawMetadata.length);
                metadata.writeBytes(rawMetadata);
                stream.putNext(metadata);
                root.clear();
                ++counter;
            }
            stream.completed();
            stream.getResult();
        }
        FlightInfo info = client.getInfo(descriptor, new CallOption[0]);
        List endpoints = info.getEndpoints();
        if (endpoints.isEmpty()) {
            throw new RuntimeException("No endpoints returned from Flight server.");
        }
        for (FlightEndpoint endpoint : info.getEndpoints()) {
            List locations = endpoint.getLocations();
            if (locations.isEmpty()) {
                IntegrationTestClient.testTicket(allocator, client, endpoint.getTicket(), inputPath);
                continue;
            }
            for (Location location : locations) {
                try {
                    FlightClient readClient = FlightClient.builder((BufferAllocator)allocator, (Location)location).build();
                    Throwable throwable = null;
                    try {
                        IntegrationTestClient.testTicket(allocator, readClient, endpoint.getTicket(), inputPath);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (readClient == null) continue;
                        IntegrationTestClient.$closeResource(throwable, (AutoCloseable)readClient);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testTicket(BufferAllocator allocator, FlightClient readClient, Ticket ticket, String inputPath) {
        try (FlightStream stream = readClient.getStream(ticket, new CallOption[0]);
             VectorSchemaRoot root = stream.getRoot();
             VectorSchemaRoot downloadedRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
             JsonFileReader reader = new JsonFileReader(new File(inputPath), allocator);){
            VectorLoader loader = new VectorLoader(downloadedRoot);
            VectorUnloader unloader = new VectorUnloader(root);
            Schema jsonSchema = reader.start();
            Validator.compareSchemas((Schema)root.getSchema(), (Schema)jsonSchema);
            try (VectorSchemaRoot jsonRoot = VectorSchemaRoot.create((Schema)jsonSchema, (BufferAllocator)allocator);){
                while (stream.next()) {
                    ArrowRecordBatch arb = unloader.getRecordBatch();
                    Throwable throwable = null;
                    try {
                        loader.load(arb);
                        if (!reader.read(jsonRoot)) throw new RuntimeException("Flight stream has more batches than JSON");
                        Validator.compareVectorSchemaRoot((VectorSchemaRoot)jsonRoot, (VectorSchemaRoot)downloadedRoot);
                        jsonRoot.clear();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (arb == null) continue;
                        IntegrationTestClient.$closeResource(throwable, (AutoCloseable)arb);
                    }
                }
                if (!reader.read(jsonRoot)) return;
                if (jsonRoot.getRowCount() <= 0) return;
                throw new RuntimeException("JSON has more batches with than Flight stream");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

