/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallInfo;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.RequestContext;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;

final class MiddlewareScenario
implements Scenario {
    private static final String HEADER = "x-middleware";
    private static final String EXPECTED_HEADER_VALUE = "expected value";
    private static final byte[] COMMAND_SUCCESS = "success".getBytes(StandardCharsets.UTF_8);

    MiddlewareScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) {
        return new NoOpFlightProducer(){

            public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
                if (descriptor.isCommand() && Arrays.equals(COMMAND_SUCCESS, descriptor.getCommand())) {
                    return new FlightInfo(new Schema(Collections.emptyList()), descriptor, Collections.emptyList(), -1L, -1L);
                }
                throw CallStatus.UNIMPLEMENTED.toRuntimeException();
            }
        };
    }

    @Override
    public void buildServer(FlightServer.Builder builder) {
        builder.middleware(FlightServerMiddleware.Key.of((String)"test"), (FlightServerMiddleware.Factory)new InjectingServerMiddleware.Factory());
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient ignored) throws Exception {
        ExtractingClientMiddleware.Factory factory = new ExtractingClientMiddleware.Factory();
        try (FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)location).intercept((FlightClientMiddleware.Factory)factory).build();){
            IntegrationAssertions.assertThrows(FlightRuntimeException.class, () -> client.getInfo(FlightDescriptor.command((byte[])new byte[0]), new CallOption[0]));
            if (!EXPECTED_HEADER_VALUE.equals(factory.extractedHeader)) {
                throw new AssertionError((Object)("Expected to extract the header value 'expected value', but found: " + factory.extractedHeader));
            }
            factory.extractedHeader = "";
            client.getInfo(FlightDescriptor.command((byte[])COMMAND_SUCCESS), new CallOption[0]);
            if (!EXPECTED_HEADER_VALUE.equals(factory.extractedHeader)) {
                throw new AssertionError((Object)("Expected to extract the header value 'expected value', but found: " + factory.extractedHeader));
            }
        }
    }

    static class ExtractingClientMiddleware
    implements FlightClientMiddleware {
        private final Factory factory;

        public ExtractingClientMiddleware(Factory factory) {
            this.factory = factory;
        }

        public void onBeforeSendingHeaders(CallHeaders outgoingHeaders) {
            outgoingHeaders.insert(MiddlewareScenario.HEADER, MiddlewareScenario.EXPECTED_HEADER_VALUE);
        }

        public void onHeadersReceived(CallHeaders incomingHeaders) {
            this.factory.extractedHeader = incomingHeaders.get(MiddlewareScenario.HEADER);
        }

        public void onCallCompleted(CallStatus status) {
        }

        static class Factory
        implements FlightClientMiddleware.Factory {
            String extractedHeader = null;

            Factory() {
            }

            public FlightClientMiddleware onCallStarted(CallInfo info) {
                return new ExtractingClientMiddleware(this);
            }
        }
    }

    static class InjectingServerMiddleware
    implements FlightServerMiddleware {
        private final String headerValue;

        InjectingServerMiddleware(String incoming) {
            this.headerValue = incoming;
        }

        public void onBeforeSendingHeaders(CallHeaders outgoingHeaders) {
            outgoingHeaders.insert(MiddlewareScenario.HEADER, this.headerValue);
        }

        public void onCallCompleted(CallStatus status) {
        }

        public void onCallErrored(Throwable err) {
        }

        static class Factory
        implements FlightServerMiddleware.Factory<InjectingServerMiddleware> {
            Factory() {
            }

            public InjectingServerMiddleware onCallStarted(CallInfo info, CallHeaders incomingHeaders, RequestContext context) {
                String incoming = incomingHeaders.get(MiddlewareScenario.HEADER);
                return new InjectingServerMiddleware(incoming == null ? "" : incoming);
            }
        }
    }
}

