/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.ToIntBiFunction;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestUIntDictionaryRoundTrip {
    private final boolean streamMode;
    private BufferAllocator allocator;
    private DictionaryProvider.MapDictionaryProvider dictionaryProvider;

    public TestUIntDictionaryRoundTrip(boolean streamMode) {
        this.streamMode = streamMode;
    }

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.dictionaryProvider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    private byte[] writeData(FieldVector encodedVector) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        VectorSchemaRoot root = new VectorSchemaRoot(Arrays.asList(encodedVector.getField()), Arrays.asList(encodedVector), encodedVector.getValueCount());
        try (ArrowStreamWriter writer = this.streamMode ? new ArrowStreamWriter(root, (DictionaryProvider)this.dictionaryProvider, (OutputStream)out) : new ArrowFileWriter(root, (DictionaryProvider)this.dictionaryProvider, Channels.newChannel(out));){
            writer.start();
            writer.writeBatch();
            writer.end();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private void readData(byte[] data, Field expectedField, ToIntBiFunction<ValueVector, Integer> valGetter, long dictionaryID, int[] expectedIndices, String[] expectedDictItems) throws IOException {
        try (ArrowStreamReader reader = this.streamMode ? new ArrowStreamReader((InputStream)new ByteArrayInputStream(data), this.allocator) : new ArrowFileReader(new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(data)), this.allocator);){
            Schema readSchema = reader.getVectorSchemaRoot().getSchema();
            Assert.assertEquals((long)1L, (long)readSchema.getFields().size());
            Assert.assertEquals((Object)expectedField, readSchema.getFields().get(0));
            Assert.assertTrue((boolean)reader.loadNextBatch());
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            Assert.assertEquals((long)1L, (long)root.getFieldVectors().size());
            FieldVector encodedVector = root.getVector(0);
            Assert.assertEquals((long)expectedIndices.length, (long)encodedVector.getValueCount());
            for (int i = 0; i < expectedIndices.length; ++i) {
                Assert.assertEquals((long)expectedIndices[i], (long)valGetter.applyAsInt((ValueVector)encodedVector, i));
            }
            Map dictVectors = reader.getDictionaryVectors();
            Assert.assertEquals((long)1L, (long)dictVectors.size());
            Dictionary dictionary = (Dictionary)dictVectors.get(dictionaryID);
            Assert.assertNotNull((Object)dictionary);
            Assert.assertTrue((boolean)(dictionary.getVector() instanceof VarCharVector));
            VarCharVector dictVector = (VarCharVector)dictionary.getVector();
            Assert.assertEquals((long)expectedDictItems.length, (long)dictVector.getValueCount());
            for (int i = 0; i < dictVector.getValueCount(); ++i) {
                Assert.assertArrayEquals((byte[])expectedDictItems[i].getBytes(), (byte[])dictVector.get(i));
            }
        }
    }

    private ValueVector createEncodedVector(int bitWidth, VarCharVector dictionaryVector) {
        DictionaryEncoding dictionaryEncoding = new DictionaryEncoding((long)bitWidth, false, new ArrowType.Int(bitWidth, false));
        Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, dictionaryEncoding);
        this.dictionaryProvider.put(dictionary);
        FieldType type = new FieldType(true, (ArrowType)dictionaryEncoding.getIndexType(), dictionaryEncoding, null);
        Field field = new Field("encoded", type, null);
        return field.createVector(this.allocator);
    }

    @Test
    public void testUInt1RoundTrip() throws IOException {
        int vectorLength = 255;
        try (VarCharVector dictionaryVector = new VarCharVector("dictionary", this.allocator);
             UInt1Vector encodedVector1 = (UInt1Vector)this.createEncodedVector(8, dictionaryVector);){
            int[] indices = new int[255];
            String[] dictionaryItems = new String[255];
            for (int i = 0; i < 255; ++i) {
                encodedVector1.setSafe(i, (byte)i);
                indices[i] = i;
                dictionaryItems[i] = String.valueOf(i);
            }
            encodedVector1.setValueCount(255);
            ValueVectorDataPopulator.setVector(dictionaryVector, dictionaryItems);
            byte[] data = this.writeData((FieldVector)encodedVector1);
            this.readData(data, encodedVector1.getField(), (vector, index) -> (int)((UInt1Vector)vector).getValueAsLong(index.intValue()), 8L, indices, dictionaryItems);
        }
    }

    @Test
    public void testUInt2RoundTrip() throws IOException {
        try (VarCharVector dictionaryVector = new VarCharVector("dictionary", this.allocator);
             UInt2Vector encodedVector2 = (UInt2Vector)this.createEncodedVector(16, dictionaryVector);){
            int[] indices = new int[]{1, 3, 5, 7, 9, 65535};
            String[] dictItems = new String[65535];
            for (int i = 0; i < 65535; ++i) {
                dictItems[i] = String.valueOf(i);
            }
            ValueVectorDataPopulator.setVector(encodedVector2, Character.valueOf('\u0001'), Character.valueOf('\u0003'), Character.valueOf('\u0005'), Character.valueOf('\u0007'), Character.valueOf('\t'), Character.valueOf('\uffff'));
            ValueVectorDataPopulator.setVector(dictionaryVector, dictItems);
            byte[] data = this.writeData((FieldVector)encodedVector2);
            this.readData(data, encodedVector2.getField(), (vector, index) -> (int)((UInt2Vector)vector).getValueAsLong(index.intValue()), 16L, indices, dictItems);
        }
    }

    @Test
    public void testUInt4RoundTrip() throws IOException {
        int dictLength = 10;
        try (VarCharVector dictionaryVector = new VarCharVector("dictionary", this.allocator);
             UInt4Vector encodedVector4 = (UInt4Vector)this.createEncodedVector(32, dictionaryVector);){
            int[] indices = new int[]{1, 3, 5, 7, 9};
            String[] dictItems = new String[10];
            for (int i = 0; i < 10; ++i) {
                dictItems[i] = String.valueOf(i);
            }
            ValueVectorDataPopulator.setVector(encodedVector4, 1, 3, 5, 7, 9);
            ValueVectorDataPopulator.setVector(dictionaryVector, dictItems);
            ValueVectorDataPopulator.setVector(encodedVector4, 1, 3, 5, 7, 9);
            byte[] data = this.writeData((FieldVector)encodedVector4);
            this.readData(data, encodedVector4.getField(), (vector, index) -> (int)((UInt4Vector)vector).getValueAsLong(index.intValue()), 32L, indices, dictItems);
        }
    }

    @Test
    public void testUInt8RoundTrip() throws IOException {
        int dictLength = 10;
        try (VarCharVector dictionaryVector = new VarCharVector("dictionary", this.allocator);
             UInt8Vector encodedVector8 = (UInt8Vector)this.createEncodedVector(64, dictionaryVector);){
            int[] indices = new int[]{1, 3, 5, 7, 9};
            String[] dictItems = new String[10];
            for (int i = 0; i < 10; ++i) {
                dictItems[i] = String.valueOf(i);
            }
            ValueVectorDataPopulator.setVector(encodedVector8, 1L, 3L, 5L, 7L, 9L);
            ValueVectorDataPopulator.setVector(dictionaryVector, dictItems);
            byte[] data = this.writeData((FieldVector)encodedVector8);
            this.readData(data, encodedVector8.getField(), (vector, index) -> (int)((UInt8Vector)vector).getValueAsLong(index.intValue()), 64L, indices, dictItems);
        }
    }

    @Parameterized.Parameters(name="stream mode = {0}")
    public static Collection<Object[]> getRepeat() {
        return Arrays.asList({true}, {false});
    }
}

