/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRoundtrip {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRoundtrip.class);
    private final Options options;
    private final PrintStream err;

    FileRoundtrip(PrintStream err) {
        this.err = err;
        this.options = new Options();
        this.options.addOption("i", "in", true, "input file");
        this.options.addOption("o", "out", true, "output file");
    }

    public static void main(String[] args) {
        System.exit(new FileRoundtrip(System.err).run(args));
    }

    private File validateFile(String type, String fileName) throws IOException {
        File parentDir;
        if (fileName == null) {
            throw new IllegalArgumentException("missing " + type + " file parameter");
        }
        File f = new File(fileName);
        if (type.equals("input")) {
            if (!f.exists() || f.isDirectory()) {
                throw new IllegalArgumentException(type + " file not found: " + f.getAbsolutePath());
            }
        } else if (type.equals("output") && (parentDir = f.getParentFile()) != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Failed to create parent directory: " + parentDir.getAbsolutePath());
        }
        return f;
    }

    int run(String[] args) {
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.options, args, false);
            String inFileName = cmd.getOptionValue("in");
            String outFileName = cmd.getOptionValue("out");
            File inFile = this.validateFile("input", inFileName);
            File outFile = this.validateFile("output", outFileName);
            try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
                 FileInputStream fileInputStream = new FileInputStream(inFile);
                 ArrowFileReader arrowReader = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), (BufferAllocator)allocator);){
                VectorSchemaRoot root = arrowReader.getVectorSchemaRoot();
                Schema schema = root.getSchema();
                LOGGER.debug("Input file size: " + inFile.length());
                LOGGER.debug("Found schema: " + schema);
                try (FileOutputStream fileOutputStream = new FileOutputStream(outFile);
                     ArrowFileWriter arrowWriter = new ArrowFileWriter(root, (DictionaryProvider)arrowReader, (WritableByteChannel)fileOutputStream.getChannel());){
                    arrowWriter.start();
                    while (arrowReader.loadNextBatch()) {
                        arrowWriter.writeBatch();
                    }
                    arrowWriter.end();
                }
                LOGGER.debug("Output file size: " + outFile.length());
            }
        }
        catch (ParseException e) {
            return this.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            return this.fatalError("Error accessing files", e);
        }
        return 0;
    }

    private int fatalError(String message, Throwable e) {
        this.err.println(message);
        LOGGER.error(message, e);
        return 1;
    }
}

