/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.file.ArrowWriter;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.stream.ArrowStreamReader;

public class StreamToFile {
    public static void convert(InputStream in, OutputStream out) throws IOException {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        try (ArrowStreamReader reader = new ArrowStreamReader(in, (BufferAllocator)allocator);){
            reader.init();
            try (ArrowWriter writer = new ArrowWriter(Channels.newChannel(out), reader.getSchema());){
                ArrowRecordBatch batch;
                while ((batch = reader.nextRecordBatch()) != null) {
                    writer.writeRecordBatch(batch);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        InputStream in = System.in;
        OutputStream out = System.out;
        if (args.length == 2) {
            in = new FileInputStream(new File(args[0]));
            out = new FileOutputStream(new File(args[1]));
        }
        StreamToFile.convert(in, out);
    }
}

