/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.file.ArrowBlock;
import org.apache.arrow.vector.file.ArrowFooter;
import org.apache.arrow.vector.file.ArrowReader;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.stream.ArrowStreamWriter;

public class FileToStream {
    public static void convert(FileInputStream in, OutputStream out) throws IOException {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        try (ArrowReader reader = new ArrowReader((SeekableByteChannel)in.getChannel(), (BufferAllocator)allocator);){
            ArrowFooter footer = reader.readFooter();
            try (ArrowStreamWriter writer = new ArrowStreamWriter(out, footer.getSchema());){
                for (ArrowBlock block : footer.getRecordBatches()) {
                    ArrowRecordBatch batch = reader.readRecordBatch(block);
                    Throwable throwable = null;
                    try {
                        writer.writeRecordBatch(batch);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (batch == null) continue;
                        if (throwable != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        batch.close();
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1 && args.length != 2) {
            System.err.println("Usage: FileToStream <input file> [output file]");
            System.exit(1);
        }
        FileInputStream in = new FileInputStream(new File(args[0]));
        OutputStream out = args.length == 1 ? System.out : new FileOutputStream(new File(args[1]));
        FileToStream.convert(in, out);
    }
}

