/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoServer.class);
    private final ServerSocket serverSocket;
    private boolean closed = false;

    public EchoServer(int port) throws IOException {
        LOGGER.info("Starting echo server.");
        this.serverSocket = new ServerSocket(port);
        LOGGER.info("Running echo server on port: " + this.port());
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new EchoServer(port).run();
    }

    public int port() {
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            while (!this.closed) {
                LOGGER.info("Waiting to accept new client connection.");
                Socket clientSocket = this.serverSocket.accept();
                LOGGER.info("Accepted new client connection.");
                try (ClientConnection client = new ClientConnection(clientSocket);){
                    try {
                        client.run();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Error handling client connection.", (Throwable)e);
                    }
                }
                LOGGER.info("Closed connection with client");
            }
        }
        catch (SocketException ex) {
            if (!this.closed) {
                throw ex;
            }
        }
        finally {
            this.serverSocket.close();
            LOGGER.info("Server closed.");
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.serverSocket.close();
    }

    public static class ClientConnection
    implements AutoCloseable {
        public final Socket socket;

        public ClientConnection(Socket socket) {
            this.socket = socket;
        }

        public void run() throws IOException {
            try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                 ArrowStreamReader reader = new ArrowStreamReader(this.socket.getInputStream(), (BufferAllocator)allocator);){
                VectorSchemaRoot root = reader.getVectorSchemaRoot();
                reader.loadNextBatch();
                try (ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)reader, this.socket.getOutputStream());){
                    int rowCount;
                    writer.start();
                    int echoed = 0;
                    while ((rowCount = reader.getVectorSchemaRoot().getRowCount()) != 0) {
                        writer.writeBatch();
                        echoed += rowCount;
                        reader.loadNextBatch();
                    }
                    writer.end();
                    Preconditions.checkState((reader.bytesRead() == writer.bytesWritten() ? 1 : 0) != 0);
                    LOGGER.info(String.format("Echoed %d records", echoed));
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
        }
    }
}

