/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class ArrowBufBenchmarks {
    private static final int BUFFER_CAPACITY = 0x100000;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private ArrowBuf buffer;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.buffer = this.allocator.buffer(0x100000L);
    }

    @TearDown
    public void tearDown() {
        this.buffer.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void setZero() {
        this.buffer.setZero(0L, 0x100000L);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ArrowBufBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

