/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class ArrowBufPointerBenchmarks {
    private static final int BUFFER_CAPACITY = 1000;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private ArrowBuf buffer1;
    private ArrowBuf buffer2;
    private ArrowBufPointer pointer1;
    private ArrowBufPointer pointer2;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.buffer1 = this.allocator.buffer(1000L);
        this.buffer2 = this.allocator.buffer(1000L);
        for (int i = 0; i < 1000; ++i) {
            this.buffer1.setByte((long)i, i);
            this.buffer2.setByte((long)i, i);
        }
        this.buffer1.setByte(999L, 12);
        this.buffer1.setByte(999L, 123);
        this.pointer1 = new ArrowBufPointer(this.buffer1, 0L, 1000L);
        this.pointer2 = new ArrowBufPointer(this.buffer2, 0L, 1000L);
    }

    @TearDown
    public void tearDown() {
        this.buffer1.close();
        this.buffer2.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int compareBenchmark() {
        return this.pointer1.compareTo(this.pointer2);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(ArrowBufPointerBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

