/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.adapter.avro.AvroToArrow;
import org.apache.arrow.adapter.avro.AvroToArrowConfig;
import org.apache.arrow.adapter.avro.AvroToArrowConfigBuilder;
import org.apache.arrow.adapter.avro.AvroToArrowVectorIterator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class AvroAdapterBenchmarks {
    private final int valueCount = 3000;
    private AvroToArrowConfig config;
    private Schema schema;
    private BinaryDecoder decoder;

    @Setup
    public void prepare() throws Exception {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        this.config = new AvroToArrowConfigBuilder((BufferAllocator)allocator).build();
        String schemaStr = "{\n \"namespace\": \"org.apache.arrow.avro\",\n \"type\": \"record\",\n \"name\": \"testBenchmark\",\n \"fields\": [\n    {\"name\": \"f0\", \"type\": \"string\"},\n    {\"name\": \"f1\", \"type\": \"int\"},\n    {\"name\": \"f2\", \"type\": \"long\"},\n    {\"name\": \"f3\", \"type\": \"boolean\"},\n    {\"name\": \"f4\", \"type\": \"float\"}\n  ]\n}";
        this.schema = new Schema.Parser().parse(schemaStr);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = new EncoderFactory().directBinaryEncoder((OutputStream)out, null);
        GenericDatumWriter writer = new GenericDatumWriter(this.schema);
        for (int i = 0; i < 3000; ++i) {
            GenericData.Record record = new GenericData.Record(this.schema);
            record.put(0, (Object)("test" + i));
            record.put(1, (Object)i);
            record.put(2, (Object)((long)i + 1L));
            record.put(3, (Object)(i % 2 == 0 ? 1 : 0));
            record.put(4, (Object)Float.valueOf((float)i + 0.1f));
            writer.write((Object)record, (Encoder)encoder);
        }
        this.decoder = new DecoderFactory().directBinaryDecoder((InputStream)new ByteArrayInputStream(out.toByteArray()), null);
    }

    @TearDown
    public void tearDown() {
        this.config.getAllocator().close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int testAvroToArrow() throws Exception {
        this.decoder.inputStream().reset();
        int sum = 0;
        try (AvroToArrowVectorIterator iter = AvroToArrow.avroToArrowIterator((Schema)this.schema, (Decoder)this.decoder, (AvroToArrowConfig)this.config);){
            while (iter.hasNext()) {
                VectorSchemaRoot root = iter.next();
                IntVector intVector = (IntVector)root.getVector("f1");
                for (int i = 0; i < intVector.getValueCount(); ++i) {
                    sum += intVector.get(i);
                }
                root.close();
            }
        }
        return sum;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(AvroAdapterBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

