/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import io.netty.util.internal.ReflectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

public class MemoryUtil {
    public static final Unsafe UNSAFE;
    public static final long BYTE_ARRAY_BASE_OFFSET;
    static final long BYTE_BUFFER_ADDRESS_OFFSET;

    public static long getByteBufferAddress(ByteBuffer buf) {
        return UNSAFE.getLong(buf, BYTE_BUFFER_ADDRESS_OFFSET);
    }

    private MemoryUtil() {
    }

    static {
        try {
            Object maybeUnsafe = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                        Throwable cause = ReflectionUtil.trySetAccessible((AccessibleObject)unsafeField, (boolean)false);
                        if (cause != null) {
                            return cause;
                        }
                        return unsafeField.get(null);
                    }
                    catch (Throwable e) {
                        return e;
                    }
                }
            });
            if (maybeUnsafe instanceof Throwable) {
                throw (Throwable)maybeUnsafe;
            }
            UNSAFE = (Unsafe)maybeUnsafe;
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            Field addressField = Buffer.class.getDeclaredField("address");
            addressField.setAccessible(true);
            BYTE_BUFFER_ADDRESS_OFFSET = UNSAFE.objectFieldOffset(addressField);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize MemoryUtil.", e);
        }
    }
}

