/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.CDataReferenceManager;
import org.apache.arrow.c.NativeUtil;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TypeLayout;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;

final class ArrayImporter {
    private static final int MAX_IMPORT_RECURSION_LEVEL = 64;
    private final BufferAllocator allocator;
    private final FieldVector vector;
    private final DictionaryProvider dictionaryProvider;
    private CDataReferenceManager referenceManager;
    private int recursionLevel;

    ArrayImporter(BufferAllocator allocator, FieldVector vector, DictionaryProvider dictionaryProvider) {
        this.allocator = allocator;
        this.vector = vector;
        this.dictionaryProvider = dictionaryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importArray(ArrowArray src) {
        ArrowArray.Snapshot snapshot = src.snapshot();
        Preconditions.checkState((snapshot.release != 0L ? 1 : 0) != 0, (Object)"Cannot import released ArrowArray");
        ArrowArray ownedArray = ArrowArray.allocateNew(this.allocator);
        ownedArray.save(snapshot);
        src.markReleased();
        src.close();
        this.recursionLevel = 0;
        this.referenceManager = new CDataReferenceManager(ownedArray);
        try {
            this.referenceManager.increment();
            this.doImport(snapshot);
        }
        finally {
            this.referenceManager.release();
        }
    }

    private void importChild(ArrayImporter parent, ArrowArray src) {
        ArrowArray.Snapshot snapshot = src.snapshot();
        Preconditions.checkState((snapshot.release != 0L ? 1 : 0) != 0, (Object)"Cannot import released ArrowArray");
        this.recursionLevel = parent.recursionLevel + 1;
        Preconditions.checkState((this.recursionLevel <= 64 ? 1 : 0) != 0, (Object)"Recursion level in ArrowArray struct exceeded");
        this.referenceManager = parent.referenceManager;
        this.doImport(snapshot);
    }

    private void doImport(ArrowArray.Snapshot snapshot) {
        long[] children = NativeUtil.toJavaArray(snapshot.children, LargeMemoryUtil.checkedCastToInt((long)snapshot.n_children));
        if (children != null && children.length > 0) {
            List childVectors = this.vector.getChildrenFromFields();
            Preconditions.checkState((children.length == childVectors.size() ? 1 : 0) != 0, (String)"ArrowArray struct has %s children (expected %s)", (int)children.length, (int)childVectors.size());
            for (int i = 0; i < children.length; ++i) {
                Preconditions.checkState((children[i] != 0L ? 1 : 0) != 0, (String)"ArrowArray struct has NULL child at position %s", (int)i);
                ArrayImporter childImporter = new ArrayImporter(this.allocator, (FieldVector)childVectors.get(i), this.dictionaryProvider);
                childImporter.importChild(this, ArrowArray.wrap(children[i]));
            }
        }
        if (snapshot.dictionary != 0L) {
            DictionaryEncoding encoding = this.vector.getField().getDictionary();
            Preconditions.checkNotNull((Object)encoding, (Object)"Missing encoding on import of ArrowArray with dictionary");
            Dictionary dictionary = this.dictionaryProvider.lookup(encoding.getId());
            Preconditions.checkNotNull((Object)dictionary, (Object)"Dictionary lookup failed on import of ArrowArray with dictionary");
            dictionary.getVector().clear();
            ArrayImporter dictionaryImporter = new ArrayImporter(this.allocator, dictionary.getVector(), this.dictionaryProvider);
            dictionaryImporter.importChild(this, ArrowArray.wrap(snapshot.dictionary));
        }
        ArrowFieldNode fieldNode = new ArrowFieldNode(snapshot.length, snapshot.null_count);
        List<ArrowBuf> buffers = this.importBuffers(snapshot);
        try {
            this.vector.loadFieldBuffers(fieldNode, buffers);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load buffers for field " + this.vector.getField() + ". error message: " + e.getMessage(), e);
        }
    }

    private List<ArrowBuf> importBuffers(ArrowArray.Snapshot snapshot) {
        long[] buffers = NativeUtil.toJavaArray(snapshot.buffers, LargeMemoryUtil.checkedCastToInt((long)snapshot.n_buffers));
        if (buffers == null || buffers.length == 0) {
            return new ArrayList<ArrowBuf>();
        }
        int buffersCount = TypeLayout.getTypeBufferCount((ArrowType)this.vector.getField().getType());
        Preconditions.checkState((buffers.length == buffersCount ? 1 : 0) != 0, (String)"Expected %s buffers for imported type %s, ArrowArray struct has %s", (Object)buffersCount, (Object)this.vector.getField().getType().getTypeID(), (Object)buffers.length);
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(buffersCount);
        for (long bufferPtr : buffers) {
            ArrowBuf buffer = null;
            if (bufferPtr != 0L) {
                int capacity = Integer.MAX_VALUE;
                buffer = new ArrowBuf((ReferenceManager)this.referenceManager, null, (long)capacity, bufferPtr);
                buffer.writerIndex((long)capacity);
            }
            result.add(buffer);
        }
        return result;
    }
}

