/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.IndexSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;

public class GeneralOutOfPlaceVectorSorter<V extends ValueVector>
implements OutOfPlaceVectorSorter<V> {
    @Override
    public void sortOutOfPlace(V srcVector, V dstVector, VectorValueComparator<V> comparator) {
        comparator.attachVector(srcVector);
        Preconditions.checkArgument((dstVector.getValueCapacity() >= srcVector.getValueCount() ? 1 : 0) != 0, (String)"Not enough capacity for the target vector. Expected capacity %s, actual capacity %s", (int)srcVector.getValueCount(), (int)dstVector.getValueCapacity());
        try (IntVector sortedIndices = new IntVector("", srcVector.getAllocator());){
            sortedIndices.allocateNew(srcVector.getValueCount());
            sortedIndices.setValueCount(srcVector.getValueCount());
            IndexSorter<V> indexSorter = new IndexSorter<V>();
            indexSorter.sort(srcVector, sortedIndices, comparator);
            for (int dstIndex = 0; dstIndex < sortedIndices.getValueCount(); ++dstIndex) {
                int srcIndex = sortedIndices.get(dstIndex);
                dstVector.copyFromSafe(srcIndex, dstIndex, srcVector);
            }
        }
    }
}

