/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.misc;

import org.apache.arrow.vector.BaseIntVector;

public class PartialSumUtils {
    public static void toPartialSumVector(BaseIntVector deltaVector, BaseIntVector partialSumVector, long sumBase) {
        long sum = sumBase;
        partialSumVector.setWithPossibleTruncate(0, sumBase);
        for (int i = 0; i < deltaVector.getValueCount(); ++i) {
            partialSumVector.setWithPossibleTruncate(i + 1, sum += deltaVector.getValueAsLong(i));
        }
        partialSumVector.setValueCount(deltaVector.getValueCount() + 1);
    }

    public static void toDeltaVector(BaseIntVector partialSumVector, BaseIntVector deltaVector) {
        for (int i = 0; i < partialSumVector.getValueCount() - 1; ++i) {
            long delta = partialSumVector.getValueAsLong(i + 1) - partialSumVector.getValueAsLong(i);
            deltaVector.setWithPossibleTruncate(i, delta);
        }
        deltaVector.setValueCount(partialSumVector.getValueCount() - 1);
    }

    public static int findPositionInPartialSumVector(BaseIntVector partialSumVector, long value) {
        if (value < partialSumVector.getValueAsLong(0) || value >= partialSumVector.getValueAsLong(partialSumVector.getValueCount() - 1)) {
            return -1;
        }
        int low = 0;
        int high = partialSumVector.getValueCount() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            long midValue = partialSumVector.getValueAsLong(mid);
            if (midValue <= value) {
                if (mid == partialSumVector.getValueCount() - 1) {
                    return mid;
                }
                long nextMidValue = partialSumVector.getValueAsLong(mid + 1);
                if (value < nextMidValue) {
                    return mid;
                }
                low = mid + 1;
                continue;
            }
            long prevMidValue = partialSumVector.getValueAsLong(mid - 1);
            if (prevMidValue <= value) {
                return mid - 1;
            }
            high = mid - 1;
        }
        throw new IllegalStateException("Should never get here");
    }

    private PartialSumUtils() {
    }
}

