/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.math.BigDecimal;
import java.time.Duration;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VariableWidthVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.RepeatedValueVector;
import org.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;

public class DefaultVectorComparators {
    public static <T extends ValueVector> VectorValueComparator<T> createDefaultComparator(T vector) {
        if (vector instanceof BaseFixedWidthVector) {
            if (vector instanceof TinyIntVector) {
                return new ByteComparator();
            }
            if (vector instanceof SmallIntVector) {
                return new ShortComparator();
            }
            if (vector instanceof IntVector) {
                return new IntComparator();
            }
            if (vector instanceof BigIntVector) {
                return new LongComparator();
            }
            if (vector instanceof Float4Vector) {
                return new Float4Comparator();
            }
            if (vector instanceof Float8Vector) {
                return new Float8Comparator();
            }
            if (vector instanceof UInt1Vector) {
                return new UInt1Comparator();
            }
            if (vector instanceof UInt2Vector) {
                return new UInt2Comparator();
            }
            if (vector instanceof UInt4Vector) {
                return new UInt4Comparator();
            }
            if (vector instanceof UInt8Vector) {
                return new UInt8Comparator();
            }
            if (vector instanceof BitVector) {
                return new BitComparator();
            }
            if (vector instanceof DateDayVector) {
                return new DateDayComparator();
            }
            if (vector instanceof DateMilliVector) {
                return new DateMilliComparator();
            }
            if (vector instanceof Decimal256Vector) {
                return new Decimal256Comparator();
            }
            if (vector instanceof DecimalVector) {
                return new DecimalComparator();
            }
            if (vector instanceof DurationVector) {
                return new DurationComparator();
            }
            if (vector instanceof IntervalDayVector) {
                return new IntervalDayComparator();
            }
            if (vector instanceof IntervalMonthDayNanoVector) {
                throw new IllegalArgumentException("No default comparator for " + vector.getClass().getCanonicalName());
            }
            if (vector instanceof TimeMicroVector) {
                return new TimeMicroComparator();
            }
            if (vector instanceof TimeMilliVector) {
                return new TimeMilliComparator();
            }
            if (vector instanceof TimeNanoVector) {
                return new TimeNanoComparator();
            }
            if (vector instanceof TimeSecVector) {
                return new TimeSecComparator();
            }
            if (vector instanceof TimeStampVector) {
                return new TimeStampComparator();
            }
            if (vector instanceof FixedSizeBinaryVector) {
                return new FixedSizeBinaryComparator();
            }
        } else {
            if (vector instanceof VariableWidthVector) {
                return new VariableWidthComparator();
            }
            if (vector instanceof RepeatedValueVector) {
                VectorValueComparator<ValueVector> innerComparator = DefaultVectorComparators.createDefaultComparator(((RepeatedValueVector)vector).getDataVector());
                return new RepeatedValueComparator<ValueVector>(innerComparator);
            }
            if (vector instanceof FixedSizeListVector) {
                VectorValueComparator<FieldVector> innerComparator = DefaultVectorComparators.createDefaultComparator(((FixedSizeListVector)vector).getDataVector());
                return new FixedSizeListComparator<FieldVector>(innerComparator);
            }
            if (vector instanceof NullVector) {
                return new NullComparator();
            }
        }
        throw new IllegalArgumentException("No default comparator for " + vector.getClass().getCanonicalName());
    }

    private DefaultVectorComparators() {
    }

    public static class FixedSizeListComparator<T extends ValueVector>
    extends VectorValueComparator<FixedSizeListVector> {
        private final VectorValueComparator<T> innerComparator;

        public FixedSizeListComparator(VectorValueComparator<T> innerComparator) {
            this.innerComparator = innerComparator;
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int length1 = ((FixedSizeListVector)this.vector1).getListSize();
            int length2 = ((FixedSizeListVector)this.vector2).getListSize();
            int length = Math.min(length1, length2);
            int startIdx1 = ((FixedSizeListVector)this.vector1).getElementStartIndex(index1);
            int startIdx2 = ((FixedSizeListVector)this.vector2).getElementStartIndex(index2);
            for (int i = 0; i < length; ++i) {
                int result = this.innerComparator.compare(startIdx1 + i, startIdx2 + i);
                if (result == 0) continue;
                return result;
            }
            return length1 - length2;
        }

        @Override
        public VectorValueComparator<FixedSizeListVector> createNew() {
            VectorValueComparator<T> newInnerComparator = this.innerComparator.createNew();
            return new FixedSizeListComparator<T>(newInnerComparator);
        }

        @Override
        public void attachVectors(FixedSizeListVector vector1, FixedSizeListVector vector2) {
            this.vector1 = vector1;
            this.vector2 = vector2;
            this.innerComparator.attachVectors(vector1.getDataVector(), vector2.getDataVector());
        }
    }

    public static class RepeatedValueComparator<T extends ValueVector>
    extends VectorValueComparator<RepeatedValueVector> {
        private final VectorValueComparator<T> innerComparator;

        public RepeatedValueComparator(VectorValueComparator<T> innerComparator) {
            this.innerComparator = innerComparator;
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int startIdx1 = ((RepeatedValueVector)this.vector1).getOffsetBuffer().getInt((long)index1 * 4L);
            int startIdx2 = ((RepeatedValueVector)this.vector2).getOffsetBuffer().getInt((long)index2 * 4L);
            int endIdx1 = ((RepeatedValueVector)this.vector1).getOffsetBuffer().getInt((long)(index1 + 1) * 4L);
            int endIdx2 = ((RepeatedValueVector)this.vector2).getOffsetBuffer().getInt((long)(index2 + 1) * 4L);
            int length1 = endIdx1 - startIdx1;
            int length2 = endIdx2 - startIdx2;
            int length = Math.min(length1, length2);
            for (int i = 0; i < length; ++i) {
                int result = this.innerComparator.compare(startIdx1 + i, startIdx2 + i);
                if (result == 0) continue;
                return result;
            }
            return length1 - length2;
        }

        @Override
        public VectorValueComparator<RepeatedValueVector> createNew() {
            VectorValueComparator<T> newInnerComparator = this.innerComparator.createNew();
            return new RepeatedValueComparator<T>(newInnerComparator);
        }

        @Override
        public void attachVectors(RepeatedValueVector vector1, RepeatedValueVector vector2) {
            this.vector1 = vector1;
            this.vector2 = vector2;
            this.innerComparator.attachVectors(vector1.getDataVector(), vector2.getDataVector());
        }
    }

    public static class VariableWidthComparator
    extends VectorValueComparator<VariableWidthVector> {
        private final ArrowBufPointer reusablePointer1 = new ArrowBufPointer();
        private final ArrowBufPointer reusablePointer2 = new ArrowBufPointer();

        @Override
        public int compare(int index1, int index2) {
            ((VariableWidthVector)this.vector1).getDataPointer(index1, this.reusablePointer1);
            ((VariableWidthVector)this.vector2).getDataPointer(index2, this.reusablePointer2);
            return this.reusablePointer1.compareTo(this.reusablePointer2);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            ((VariableWidthVector)this.vector1).getDataPointer(index1, this.reusablePointer1);
            ((VariableWidthVector)this.vector2).getDataPointer(index2, this.reusablePointer2);
            return this.reusablePointer1.compareTo(this.reusablePointer2);
        }

        @Override
        public VectorValueComparator<VariableWidthVector> createNew() {
            return new VariableWidthComparator();
        }
    }

    public static class NullComparator
    extends VectorValueComparator<NullVector> {
        @Override
        public int compare(int index1, int index2) {
            return 0;
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            throw new AssertionError((Object)"Cannot compare non-null values in a NullVector.");
        }

        @Override
        public VectorValueComparator<NullVector> createNew() {
            return new NullComparator();
        }
    }

    public static class FixedSizeBinaryComparator
    extends VectorValueComparator<FixedSizeBinaryVector> {
        @Override
        public int compare(int index1, int index2) {
            NullableFixedSizeBinaryHolder holder1 = new NullableFixedSizeBinaryHolder();
            NullableFixedSizeBinaryHolder holder2 = new NullableFixedSizeBinaryHolder();
            ((FixedSizeBinaryVector)this.vector1).get(index1, holder1);
            ((FixedSizeBinaryVector)this.vector2).get(index2, holder2);
            return ByteFunctionHelpers.compare((ArrowBuf)holder1.buffer, (long)0L, (long)holder1.byteWidth, (ArrowBuf)holder2.buffer, (long)0L, (long)holder2.byteWidth);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            NullableFixedSizeBinaryHolder holder1 = new NullableFixedSizeBinaryHolder();
            NullableFixedSizeBinaryHolder holder2 = new NullableFixedSizeBinaryHolder();
            ((FixedSizeBinaryVector)this.vector1).get(index1, holder1);
            ((FixedSizeBinaryVector)this.vector2).get(index2, holder2);
            return ByteFunctionHelpers.compare((ArrowBuf)holder1.buffer, (long)0L, (long)holder1.byteWidth, (ArrowBuf)holder2.buffer, (long)0L, (long)holder2.byteWidth);
        }

        @Override
        public VectorValueComparator<FixedSizeBinaryVector> createNew() {
            return new FixedSizeBinaryComparator();
        }
    }

    public static class TimeStampComparator
    extends VectorValueComparator<TimeStampVector> {
        public TimeStampComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            long value1 = ((TimeStampVector)this.vector1).get(index1);
            long value2 = ((TimeStampVector)this.vector2).get(index2);
            return Long.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<TimeStampVector> createNew() {
            return new TimeStampComparator();
        }
    }

    public static class TimeSecComparator
    extends VectorValueComparator<TimeSecVector> {
        public TimeSecComparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int value1 = ((TimeSecVector)this.vector1).get(index1);
            int value2 = ((TimeSecVector)this.vector2).get(index2);
            return Integer.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<TimeSecVector> createNew() {
            return new TimeSecComparator();
        }
    }

    public static class TimeNanoComparator
    extends VectorValueComparator<TimeNanoVector> {
        public TimeNanoComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            long value1 = ((TimeNanoVector)this.vector1).get(index1);
            long value2 = ((TimeNanoVector)this.vector2).get(index2);
            return Long.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<TimeNanoVector> createNew() {
            return new TimeNanoComparator();
        }
    }

    public static class TimeMilliComparator
    extends VectorValueComparator<TimeMilliVector> {
        public TimeMilliComparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int value1 = ((TimeMilliVector)this.vector1).get(index1);
            int value2 = ((TimeMilliVector)this.vector2).get(index2);
            return Integer.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<TimeMilliVector> createNew() {
            return new TimeMilliComparator();
        }
    }

    public static class TimeMicroComparator
    extends VectorValueComparator<TimeMicroVector> {
        public TimeMicroComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            long value1 = ((TimeMicroVector)this.vector1).get(index1);
            long value2 = ((TimeMicroVector)this.vector2).get(index2);
            return Long.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<TimeMicroVector> createNew() {
            return new TimeMicroComparator();
        }
    }

    public static class IntervalDayComparator
    extends VectorValueComparator<IntervalDayVector> {
        public IntervalDayComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            Duration value1 = ((IntervalDayVector)this.vector1).getObjectNotNull(index1);
            Duration value2 = ((IntervalDayVector)this.vector2).getObjectNotNull(index2);
            return value1.compareTo(value2);
        }

        @Override
        public VectorValueComparator<IntervalDayVector> createNew() {
            return new IntervalDayComparator();
        }
    }

    public static class DurationComparator
    extends VectorValueComparator<DurationVector> {
        public DurationComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            Duration value1 = ((DurationVector)this.vector1).getObjectNotNull(index1);
            Duration value2 = ((DurationVector)this.vector2).getObjectNotNull(index2);
            return value1.compareTo(value2);
        }

        @Override
        public VectorValueComparator<DurationVector> createNew() {
            return new DurationComparator();
        }
    }

    public static class DecimalComparator
    extends VectorValueComparator<DecimalVector> {
        public DecimalComparator() {
            super(16);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            BigDecimal value1 = ((DecimalVector)this.vector1).getObjectNotNull(index1);
            BigDecimal value2 = ((DecimalVector)this.vector2).getObjectNotNull(index2);
            return value1.compareTo(value2);
        }

        @Override
        public VectorValueComparator<DecimalVector> createNew() {
            return new DecimalComparator();
        }
    }

    public static class Decimal256Comparator
    extends VectorValueComparator<Decimal256Vector> {
        public Decimal256Comparator() {
            super(32);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            BigDecimal value1 = ((Decimal256Vector)this.vector1).getObjectNotNull(index1);
            BigDecimal value2 = ((Decimal256Vector)this.vector2).getObjectNotNull(index2);
            return value1.compareTo(value2);
        }

        @Override
        public VectorValueComparator<Decimal256Vector> createNew() {
            return new Decimal256Comparator();
        }
    }

    public static class DateMilliComparator
    extends VectorValueComparator<DateMilliVector> {
        public DateMilliComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            long value1 = ((DateMilliVector)this.vector1).get(index1);
            long value2 = ((DateMilliVector)this.vector2).get(index2);
            return Long.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<DateMilliVector> createNew() {
            return new DateMilliComparator();
        }
    }

    public static class DateDayComparator
    extends VectorValueComparator<DateDayVector> {
        public DateDayComparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int value1 = ((DateDayVector)this.vector1).get(index1);
            int value2 = ((DateDayVector)this.vector2).get(index2);
            return Integer.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<DateDayVector> createNew() {
            return new DateDayComparator();
        }
    }

    public static class BitComparator
    extends VectorValueComparator<BitVector> {
        public BitComparator() {
            super(-1);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            boolean value1 = ((BitVector)this.vector1).get(index1) != 0;
            boolean value2 = ((BitVector)this.vector2).get(index2) != 0;
            return Boolean.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<BitVector> createNew() {
            return new BitComparator();
        }
    }

    public static class Float8Comparator
    extends VectorValueComparator<Float8Vector> {
        public Float8Comparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            double value1 = ((Float8Vector)this.vector1).get(index1);
            double value2 = ((Float8Vector)this.vector2).get(index2);
            boolean isNan1 = Double.isNaN(value1);
            boolean isNan2 = Double.isNaN(value2);
            if (isNan1 || isNan2) {
                if (isNan1 && isNan2) {
                    return 0;
                }
                if (isNan1) {
                    return 1;
                }
                return -1;
            }
            return (int)Math.signum(value1 - value2);
        }

        @Override
        public VectorValueComparator<Float8Vector> createNew() {
            return new Float8Comparator();
        }
    }

    public static class Float4Comparator
    extends VectorValueComparator<Float4Vector> {
        public Float4Comparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            float value1 = ((Float4Vector)this.vector1).get(index1);
            float value2 = ((Float4Vector)this.vector2).get(index2);
            boolean isNan1 = Float.isNaN(value1);
            boolean isNan2 = Float.isNaN(value2);
            if (isNan1 || isNan2) {
                if (isNan1 && isNan2) {
                    return 0;
                }
                if (isNan1) {
                    return 1;
                }
                return -1;
            }
            return (int)Math.signum(value1 - value2);
        }

        @Override
        public VectorValueComparator<Float4Vector> createNew() {
            return new Float4Comparator();
        }
    }

    public static class UInt8Comparator
    extends VectorValueComparator<UInt8Vector> {
        public UInt8Comparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            long value1 = ((UInt8Vector)this.vector1).get(index1);
            long value2 = ((UInt8Vector)this.vector2).get(index2);
            return ByteFunctionHelpers.unsignedLongCompare((long)value1, (long)value2);
        }

        @Override
        public VectorValueComparator<UInt8Vector> createNew() {
            return new UInt8Comparator();
        }
    }

    public static class UInt4Comparator
    extends VectorValueComparator<UInt4Vector> {
        public UInt4Comparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int value1 = ((UInt4Vector)this.vector1).get(index1);
            int value2 = ((UInt4Vector)this.vector2).get(index2);
            return ByteFunctionHelpers.unsignedIntCompare((int)value1, (int)value2);
        }

        @Override
        public VectorValueComparator<UInt4Vector> createNew() {
            return new UInt4Comparator();
        }
    }

    public static class UInt2Comparator
    extends VectorValueComparator<UInt2Vector> {
        public UInt2Comparator() {
            super(2);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            char value1 = ((UInt2Vector)this.vector1).get(index1);
            char value2 = ((UInt2Vector)this.vector2).get(index2);
            return (value1 & 0xFFFF) - (value2 & 0xFFFF);
        }

        @Override
        public VectorValueComparator<UInt2Vector> createNew() {
            return new UInt2Comparator();
        }
    }

    public static class UInt1Comparator
    extends VectorValueComparator<UInt1Vector> {
        public UInt1Comparator() {
            super(1);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            byte value1 = ((UInt1Vector)this.vector1).get(index1);
            byte value2 = ((UInt1Vector)this.vector2).get(index2);
            return (value1 & 0xFF) - (value2 & 0xFF);
        }

        @Override
        public VectorValueComparator<UInt1Vector> createNew() {
            return new UInt1Comparator();
        }
    }

    public static class LongComparator
    extends VectorValueComparator<BigIntVector> {
        public LongComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            long value1 = ((BigIntVector)this.vector1).get(index1);
            long value2 = ((BigIntVector)this.vector2).get(index2);
            return Long.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<BigIntVector> createNew() {
            return new LongComparator();
        }
    }

    public static class IntComparator
    extends VectorValueComparator<IntVector> {
        public IntComparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int value1 = ((IntVector)this.vector1).get(index1);
            int value2 = ((IntVector)this.vector2).get(index2);
            return Integer.compare(value1, value2);
        }

        @Override
        public VectorValueComparator<IntVector> createNew() {
            return new IntComparator();
        }
    }

    public static class ShortComparator
    extends VectorValueComparator<SmallIntVector> {
        public ShortComparator() {
            super(2);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            short value1 = ((SmallIntVector)this.vector1).get(index1);
            short value2 = ((SmallIntVector)this.vector2).get(index2);
            return value1 - value2;
        }

        @Override
        public VectorValueComparator<SmallIntVector> createNew() {
            return new ShortComparator();
        }
    }

    public static class ByteComparator
    extends VectorValueComparator<TinyIntVector> {
        public ByteComparator() {
            super(1);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            byte value1 = ((TinyIntVector)this.vector1).get(index1);
            byte value2 = ((TinyIntVector)this.vector2).get(index2);
            return value1 - value2;
        }

        @Override
        public VectorValueComparator<TinyIntVector> createNew() {
            return new ByteComparator();
        }
    }
}

