/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.stream.IntStream;
import org.apache.arrow.algorithm.sort.InsertionSorter;
import org.apache.arrow.algorithm.sort.OffHeapIntStack;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;

public class IndexSorter<V extends ValueVector> {
    public static final int CHANGE_ALGORITHM_THRESHOLD = 15;
    private VectorValueComparator<V> comparator;
    private IntVector indices;

    public void sort(V vector, IntVector indices, VectorValueComparator<V> comparator) {
        comparator.attachVector(vector);
        this.indices = indices;
        IntStream.range(0, vector.getValueCount()).forEach(i -> indices.set(i, i));
        this.comparator = comparator;
        this.quickSort();
    }

    private void quickSort() {
        try (OffHeapIntStack rangeStack = new OffHeapIntStack(this.indices.getAllocator());){
            rangeStack.push(0);
            rangeStack.push(this.indices.getValueCount() - 1);
            while (!rangeStack.isEmpty()) {
                int high = rangeStack.pop();
                int low = rangeStack.pop();
                if (low >= high) continue;
                if (high - low < 15) {
                    InsertionSorter.insertionSort(this.indices, low, high, this.comparator);
                    continue;
                }
                int mid = IndexSorter.partition(low, high, this.indices, this.comparator);
                if (high - mid < mid - low) {
                    rangeStack.push(low);
                    rangeStack.push(mid - 1);
                    rangeStack.push(mid + 1);
                    rangeStack.push(high);
                    continue;
                }
                rangeStack.push(mid + 1);
                rangeStack.push(high);
                rangeStack.push(low);
                rangeStack.push(mid - 1);
            }
        }
    }

    static <T extends ValueVector> int choosePivot(int low, int high, IntVector indices, VectorValueComparator<T> comparator) {
        if (high - low + 1 < 3) {
            return indices.get(low);
        }
        int mid = low + (high - low) / 2;
        int medianIdx = comparator.compare(indices.get(low), indices.get(mid)) < 0 ? (comparator.compare(indices.get(mid), indices.get(high)) < 0 ? mid : (comparator.compare(indices.get(low), indices.get(high)) < 0 ? high : low)) : (comparator.compare(indices.get(mid), indices.get(high)) > 0 ? mid : (comparator.compare(indices.get(low), indices.get(high)) < 0 ? low : high));
        if (medianIdx != low) {
            int tmp = indices.get(medianIdx);
            indices.set(medianIdx, indices.get(low));
            indices.set(low, tmp);
            return tmp;
        }
        return indices.get(low);
    }

    public static <T extends ValueVector> int partition(int low, int high, IntVector indices, VectorValueComparator<T> comparator) {
        int pivotIndex = IndexSorter.choosePivot(low, high, indices, comparator);
        while (low < high) {
            while (low < high && comparator.compare(indices.get(high), pivotIndex) >= 0) {
                --high;
            }
            indices.set(low, indices.get(high));
            while (low < high && comparator.compare(indices.get(low), pivotIndex) <= 0) {
                ++low;
            }
            indices.set(high, indices.get(low));
        }
        indices.set(low, pivotIndex);
        return low;
    }
}

