/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import io.netty.buffer.ArrowBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.arrow.algorithm.sort.IndexSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;

public class FixedWidthOutOfPlaceVectorSorter<V extends BaseFixedWidthVector>
implements OutOfPlaceVectorSorter<V> {
    protected IndexSorter<V> indexSorter = new IndexSorter();

    @Override
    public void sortOutOfPlace(V srcVector, V dstVector, VectorValueComparator<V> comparator) {
        comparator.attachVector(srcVector);
        int valueWidth = comparator.getValueWidth();
        ArrowBuf srcValueBuffer = srcVector.getDataBuffer();
        ArrowBuf dstValidityBuffer = dstVector.getValidityBuffer();
        ArrowBuf dstValueBuffer = dstVector.getDataBuffer();
        try (IntVector sortedIndices = new IntVector("", srcVector.getAllocator());){
            sortedIndices.allocateNew(srcVector.getValueCount());
            sortedIndices.setValueCount(srcVector.getValueCount());
            this.indexSorter.sort(srcVector, sortedIndices, comparator);
            for (int dstIndex = 0; dstIndex < sortedIndices.getValueCount(); ++dstIndex) {
                int srcIndex = sortedIndices.get(dstIndex);
                if (srcVector.isNull(srcIndex)) {
                    BitVectorHelper.unsetBit((ArrowBuf)dstValidityBuffer, (int)dstIndex);
                    continue;
                }
                BitVectorHelper.setBit((ArrowBuf)dstValidityBuffer, (int)dstIndex);
                PlatformDependent.copyMemory((long)(srcValueBuffer.memoryAddress() + (long)(srcIndex * valueWidth)), (long)(dstValueBuffer.memoryAddress() + (long)(dstIndex * valueWidth)), (long)valueWidth);
            }
        }
    }
}

