/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import java.util.TreeSet;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.ValueVector;

public class SearchTreeBasedDictionaryBuilder<V extends ValueVector> {
    private final V dictionary;
    protected final VectorValueComparator<V> comparator;
    private final boolean encodeNull;
    private TreeSet<Integer> searchTree;

    public SearchTreeBasedDictionaryBuilder(V dictionary, VectorValueComparator<V> comparator) {
        this(dictionary, comparator, false);
    }

    public SearchTreeBasedDictionaryBuilder(V dictionary, VectorValueComparator<V> comparator, boolean encodeNull) {
        this.dictionary = dictionary;
        this.comparator = comparator;
        this.encodeNull = encodeNull;
        this.comparator.attachVector(dictionary);
        this.searchTree = new TreeSet((index1, index2) -> comparator.compare((int)index1, (int)index2));
    }

    public V getDictionary() {
        return this.dictionary;
    }

    public int addValues(V targetVector) {
        int oldDictSize = this.dictionary.getValueCount();
        for (int i = 0; i < targetVector.getValueCount(); ++i) {
            if (!this.encodeNull && targetVector.isNull(i)) continue;
            this.addValue(targetVector, i);
        }
        return this.dictionary.getValueCount() - oldDictSize;
    }

    public int addValue(V targetVector, int targetIndex) {
        int dictSize = this.dictionary.getValueCount();
        this.dictionary.copyFromSafe(targetIndex, dictSize, targetVector);
        if (this.searchTree.add(dictSize)) {
            this.dictionary.setValueCount(dictSize + 1);
            return dictSize;
        }
        return this.searchTree.ceiling(dictSize);
    }

    public void populateSortedDictionary(V sortedDictionary) {
        int idx = 0;
        for (Integer dictIdx : this.searchTree) {
            sortedDictionary.copyFromSafe(dictIdx.intValue(), idx++, this.dictionary);
        }
        sortedDictionary.setValueCount(this.dictionary.getValueCount());
    }
}

