/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.activemq.console.Main;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class BrokerMojo
extends AbstractMojo {
    private File outputDirectory;
    private File configFile;
    private String url;

    public void execute() throws MojoExecutionException {
        File out = this.outputDirectory;
        if (!out.exists()) {
            out.mkdirs();
        }
        String[] args = new String[2];
        if (this.configFile != null) {
            File config;
            try {
                config = this.copy(this.configFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
            args[0] = "start";
            args[1] = "xbean:" + config.toURI().toString();
        } else {
            args[0] = "start";
            args[1] = this.url;
        }
        Main.main((String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File copy(File source) throws IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        File dest = new File(this.outputDirectory.getAbsolutePath() + File.separator + source.getName());
        try {
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = in.size();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return dest;
    }
}

