/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.apache.activemq.tool.properties.AbstractObjectProperties;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.apache.activemq.tool.properties.JmsClientSystemProperties;
import org.apache.activemq.tool.properties.JmsFactoryProperties;
import org.apache.activemq.tool.properties.ReflectionUtil;
import org.apache.activemq.tool.reports.PerformanceReportWriter;
import org.apache.activemq.tool.reports.VerbosePerfReportWriter;
import org.apache.activemq.tool.reports.XmlFilePerfReportWriter;
import org.apache.activemq.tool.sampler.CpuSamplerTask;
import org.apache.activemq.tool.sampler.ThroughputSamplerTask;
import org.apache.activemq.tool.spi.SPIConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJmsClientSystem
extends AbstractObjectProperties {
    private static final Log log = LogFactory.getLog((Class)AbstractJmsClientSystem.class);
    private int clientDestIndex;
    private int clientDestCount;
    protected ThreadGroup clientThreadGroup;
    protected ConnectionFactory jmsConnFactory;
    protected JmsFactoryProperties factory = new JmsFactoryProperties();
    protected ThroughputSamplerTask tpSampler = new ThroughputSamplerTask();
    protected CpuSamplerTask cpuSampler = new CpuSamplerTask();

    public void runSystemTest() throws JMSException {
        this.jmsConnFactory = this.loadJmsFactory(this.getSysTest().getSpiClass(), this.factory.getFactorySettings());
        this.setProviderMetaData(this.jmsConnFactory.createConnection().getMetaData(), this.getJmsClientProperties());
        PerformanceReportWriter writer = this.createPerfWriter();
        this.tpSampler.setPerfReportWriter(writer);
        this.cpuSampler.setPerfReportWriter(writer);
        writer.openReportWriter();
        writer.writeProperties("jvmSettings", System.getProperties());
        writer.writeProperties("testSystemSettings", ReflectionUtil.retrieveObjectProperties(this.getSysTest()));
        writer.writeProperties("jmsFactorySettings", ReflectionUtil.retrieveObjectProperties(this.jmsConnFactory));
        writer.writeProperties("jmsClientSettings", ReflectionUtil.retrieveObjectProperties(this.getJmsClientProperties()));
        writer.writeProperties("tpSamplerSettings", ReflectionUtil.retrieveObjectProperties(this.tpSampler));
        writer.writeProperties("cpuSamplerSettings", ReflectionUtil.retrieveObjectProperties(this.cpuSampler));
        this.clientThreadGroup = new ThreadGroup(this.getSysTest().getClientPrefix() + " Thread Group");
        for (int i = 0; i < this.getSysTest().getNumClients(); ++i) {
            this.distributeDestinations(this.getSysTest().getDestDistro(), i, this.getSysTest().getNumClients(), this.getSysTest().getTotalDests());
            final String clientName = this.getSysTest().getClientPrefix() + i;
            final int clientDestIndex = this.clientDestIndex;
            final int clientDestCount = this.clientDestCount;
            Thread t = new Thread(this.clientThreadGroup, new Runnable(){

                public void run() {
                    AbstractJmsClientSystem.this.runJmsClient(clientName, clientDestIndex, clientDestCount);
                }
            });
            t.setName(this.getSysTest().getClientPrefix() + i + " Thread");
            t.start();
        }
        if (this.getSysTest().getSamplers().indexOf("tp") > -1) {
            this.tpSampler.startSampler();
        }
        if (this.getSysTest().getSamplers().indexOf("cpu") > -1) {
            try {
                this.cpuSampler.createPlugin();
                this.cpuSampler.startSampler();
            }
            catch (IOException e) {
                log.warn((Object)("Unable to start CPU sampler plugin. Reason: " + e.getMessage()));
            }
        }
        this.tpSampler.waitUntilDone();
        this.cpuSampler.waitUntilDone();
        writer.closeReportWriter();
    }

    public ThroughputSamplerTask getTpSampler() {
        return this.tpSampler;
    }

    public void setTpSampler(ThroughputSamplerTask tpSampler) {
        this.tpSampler = tpSampler;
    }

    public CpuSamplerTask getCpuSampler() {
        return this.cpuSampler;
    }

    public void setCpuSampler(CpuSamplerTask cpuSampler) {
        this.cpuSampler = cpuSampler;
    }

    public JmsFactoryProperties getFactory() {
        return this.factory;
    }

    public void setFactory(JmsFactoryProperties factory) {
        this.factory = factory;
    }

    public abstract JmsClientSystemProperties getSysTest();

    public abstract void setSysTest(JmsClientSystemProperties var1);

    public abstract JmsClientProperties getJmsClientProperties();

    protected PerformanceReportWriter createPerfWriter() {
        if (this.getSysTest().getReportType().equalsIgnoreCase("xml")) {
            String reportName = this.getSysTest().getReportName();
            if (reportName == null) {
                reportName = this.getSysTest().getClientPrefix() + "_" + "numClients" + this.getSysTest().getNumClients() + "_" + "numDests" + this.getSysTest().getTotalDests() + "_" + this.getSysTest().getDestDistro();
            }
            return new XmlFilePerfReportWriter(this.getSysTest().getReportDir(), reportName);
        }
        if (this.getSysTest().getReportType().equalsIgnoreCase("verbose")) {
            return new VerbosePerfReportWriter();
        }
        return new VerbosePerfReportWriter();
    }

    protected void distributeDestinations(String distroType, int clientIndex, int numClients, int numDests) {
        if (distroType.equalsIgnoreCase("all")) {
            this.clientDestCount = numDests;
            this.clientDestIndex = 0;
        } else if (distroType.equalsIgnoreCase("equal")) {
            int destPerClient = numDests / numClients;
            if (destPerClient > 0) {
                this.clientDestCount = destPerClient;
                this.clientDestIndex = destPerClient * clientIndex;
            } else {
                this.clientDestCount = 1;
                this.clientDestIndex = clientIndex % numDests;
            }
        } else if (distroType.equalsIgnoreCase("divide")) {
            int destPerClient = numDests / numClients;
            if (destPerClient > 0) {
                int remain = numDests % numClients;
                int nextIndex = clientIndex < remain ? clientIndex * ++destPerClient : clientIndex * destPerClient + remain;
                this.clientDestCount = destPerClient;
                this.clientDestIndex = nextIndex;
            } else {
                this.clientDestCount = 1;
                this.clientDestIndex = clientIndex % numDests;
            }
        } else {
            log.warn((Object)("Unknown destination distribution type: " + distroType));
            this.clientDestCount = numDests;
            this.clientDestIndex = 0;
        }
    }

    protected ConnectionFactory loadJmsFactory(String spiClass, Properties factorySettings) throws JMSException {
        try {
            Class<?> spi = Class.forName(spiClass);
            SPIConnectionFactory spiFactory = (SPIConnectionFactory)spi.newInstance();
            ConnectionFactory jmsFactory = spiFactory.createConnectionFactory(factorySettings);
            log.info((Object)("Created: " + jmsFactory.getClass().getName() + " using SPIConnectionFactory: " + spiFactory.getClass().getName()));
            return jmsFactory;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JMSException(e.getMessage());
        }
    }

    protected void setProviderMetaData(ConnectionMetaData metaData, JmsClientProperties props) throws JMSException {
        props.setJmsProvider(metaData.getJMSProviderName() + "-" + metaData.getProviderVersion());
        props.setJmsVersion(metaData.getJMSVersion());
        String jmsProperties = "";
        Enumeration jmsProps = metaData.getJMSXPropertyNames();
        while (jmsProps.hasMoreElements()) {
            jmsProperties = jmsProperties + jmsProps.nextElement().toString() + ",";
        }
        if (jmsProperties.length() > 0) {
            jmsProperties = jmsProperties.substring(0, jmsProperties.length() - 1);
        }
        props.setJmsProperties(jmsProperties);
    }

    protected abstract void runJmsClient(String var1, int var2, int var3);

    protected static Properties parseStringArgs(String[] args) {
        File configFile = null;
        Properties props = new Properties();
        if (args == null || args.length == 0) {
            return props;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-D") || arg.startsWith("-d")) {
                arg = arg.substring(2);
            }
            int index = arg.indexOf("=");
            String key = arg.substring(0, index);
            String val = arg.substring(index + 1);
            if (key.equalsIgnoreCase("sysTest.propsConfigFile")) {
                if (!val.endsWith(".properties")) {
                    val = val + ".properties";
                }
                configFile = new File(val);
            }
            props.setProperty(key, val);
        }
        Properties fileProps = new Properties();
        try {
            if (configFile != null) {
                log.info((Object)("Loading properties file: " + configFile.getAbsolutePath()));
                fileProps.load(new FileInputStream(configFile));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        fileProps.putAll((Map<?, ?>)props);
        return fileProps;
    }
}

