/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportGenerator {
    private static final Log log = LogFactory.getLog((Class)ReportGenerator.class);
    private String reportDirectory = null;
    private String reportName = null;
    private PrintWriter writer = null;
    private File reportFile = null;
    private Properties testSettings;

    public ReportGenerator() {
    }

    public ReportGenerator(String reportDirectory, String reportName) {
        this.setReportDirectory(reportDirectory);
        this.setReportName(reportName);
    }

    public void startGenerateReport() {
        File reportDir = new File(this.getReportDirectory());
        if (!reportDir.exists()) {
            reportDir.mkdirs();
        }
        if (reportDir != null) {
            this.reportFile = new File(this.getReportDirectory() + File.separator + this.getReportName() + ".xml");
        }
        try {
            this.writer = new PrintWriter(new FileOutputStream(this.reportFile));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void stopGenerateReport() {
        this.writeWithIndent(0, "</test-report>");
        this.getWriter().flush();
        this.getWriter().close();
        log.info((Object)(" TEST REPORT OUTPUT : " + this.reportFile.getAbsolutePath()));
    }

    protected void addTestInformation() {
        this.writeWithIndent(0, "<test-report>");
        this.writeWithIndent(2, "<test-information>");
        this.writeWithIndent(4, "<os-name>" + System.getProperty("os.name") + "</os-name>");
        this.writeWithIndent(4, "<java-version>" + System.getProperty("java.version") + "</java-version>");
    }

    protected void addClientSettings() {
        if (this.getTestSettings() != null) {
            Enumeration<?> keys = this.getTestSettings().propertyNames();
            this.writeWithIndent(4, "<test-settings>");
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.writeWithIndent(6, "<" + key + ">" + this.getTestSettings().get(key) + "</" + key + ">");
            }
            this.writeWithIndent(4, "</test-settings>");
        }
    }

    protected void endTestInformation() {
        this.writeWithIndent(2, "</test-information>");
    }

    protected void startTestResult(long checkpointInterval) {
        long intervalInSec = checkpointInterval / 1000L;
        this.writeWithIndent(2, "<test-result checkpoint_interval_in_sec=" + intervalInSec + " >");
    }

    protected void endTestResult() {
        this.writeWithIndent(2, "</test-result>");
    }

    protected void writeWithIndent(int indent, String result) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
        buffer.append(result);
        this.writer.println(buffer.toString());
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public Properties getTestSettings() {
        return this.testSettings;
    }

    public void setTestSettings(Properties testSettings) {
        this.testSettings = testSettings;
    }
}

