/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.sampler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.tool.ClientRunBasis;
import org.apache.activemq.tool.properties.AbstractObjectProperties;
import org.apache.activemq.tool.reports.PerformanceReportWriter;
import org.apache.activemq.tool.sampler.PerformanceEventListener;
import org.apache.activemq.tool.sampler.PerformanceSampler;
import org.apache.activemq.tool.sampler.RampDownNotifier;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPerformanceSampler
extends AbstractObjectProperties
implements PerformanceSampler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected long rampUpPercent = 0L;
    protected long rampDownPercent = 0L;
    protected Long rampUpTime;
    protected Long rampDownTime;
    protected Long duration;
    protected long interval = 1000L;
    protected PerformanceReportWriter perfReportWriter;
    protected PerformanceEventListener perfEventListener;
    protected final AtomicBoolean isRunning = new AtomicBoolean(false);
    protected CountDownLatch completionLatch;
    protected long sampleIndex;

    @Override
    public Long getRampUpTime() {
        return this.rampUpTime;
    }

    @Override
    public void setRampUpTime(long rampUpTime) {
        this.rampUpTime = rampUpTime;
    }

    @Override
    public Long getRampDownTime() {
        return this.rampDownTime;
    }

    @Override
    public void setRampDownTime(long rampDownTime) {
        this.rampDownTime = rampDownTime;
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public long getRampUpPercent() {
        return this.rampUpPercent;
    }

    @Override
    public void setRampUpPercent(long rampUpPercent) {
        Validate.isTrue((rampUpPercent >= 0L && rampUpPercent <= 100L ? 1 : 0) != 0, (String)"rampUpPercent must be a value between 0 and 100", (Object[])new Object[0]);
        this.rampUpPercent = rampUpPercent;
    }

    @Override
    public long getRampDownPercent() {
        return this.rampDownPercent;
    }

    @Override
    public void setRampDownPercent(long rampDownPercent) {
        Validate.isTrue((rampDownPercent >= 0L && rampDownPercent < 100L ? 1 : 0) != 0, (String)"rampDownPercent must be a value between 0 and 99", (Object[])new Object[0]);
        this.rampDownPercent = rampDownPercent;
    }

    @Override
    public PerformanceReportWriter getPerfReportWriter() {
        return this.perfReportWriter;
    }

    @Override
    public void setPerfReportWriter(PerformanceReportWriter perfReportWriter) {
        this.perfReportWriter = perfReportWriter;
    }

    @Override
    public PerformanceEventListener getPerfEventListener() {
        return this.perfEventListener;
    }

    @Override
    public void setPerfEventListener(PerformanceEventListener perfEventListener) {
        this.perfEventListener = perfEventListener;
    }

    @Override
    public void startSampler(CountDownLatch completionLatch, ClientRunBasis clientRunBasis, long clientRunDuration) {
        Validate.notNull((Object)((Object)clientRunBasis));
        Validate.notNull((Object)completionLatch);
        if (clientRunBasis == ClientRunBasis.time) {
            this.duration = this.duration == null ? clientRunDuration : this.duration;
            this.rampUpTime = this.rampUpTime == null ? this.duration / 100L * this.rampUpPercent : this.rampUpTime;
            this.rampDownTime = this.rampDownTime == null ? this.duration / 100L * this.rampDownPercent : this.rampDownTime;
            Validate.isTrue((this.duration >= this.rampUpTime + this.rampDownTime ? 1 : 0) != 0, (String)("Ramp times (up: " + this.rampDownTime + ", down: " + this.rampDownTime + ") exceed the sampler duration (" + this.duration + ")"), (Object[])new Object[0]);
            this.log.info("Sampling duration: {} ms, ramp up: {} ms, ramp down: {} ms", new Object[]{this.duration, this.rampUpTime, this.rampDownTime});
            Thread notifier = new Thread(new RampDownNotifier(this));
            notifier.setName("RampDownNotifier[" + this.getClass().getSimpleName() + "]");
            notifier.start();
        } else {
            this.log.info("Performance test running on count basis; ignoring duration and ramp times");
            this.setRampUpTime(0L);
            this.setRampDownTime(0L);
        }
        this.completionLatch = completionLatch;
        Thread t = new Thread(this);
        t.setName(this.getClass().getSimpleName());
        t.start();
        this.isRunning.set(true);
    }

    @Override
    public void finishSampling() {
        this.isRunning.set(false);
    }

    @Override
    public void run() {
        try {
            this.log.debug("Ramp up start");
            this.onRampUpStart();
            if (this.perfEventListener != null) {
                this.perfEventListener.onRampUpStart(this);
            }
            if (this.rampUpTime > 0L) {
                try {
                    Thread.sleep(this.rampUpTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.log.debug("Sampler start");
            this.onSamplerStart();
            if (this.perfEventListener != null) {
                this.perfEventListener.onSamplerStart(this);
            }
            this.sample();
            this.log.debug("Sampler end");
            this.onSamplerEnd();
            if (this.perfEventListener != null) {
                this.perfEventListener.onSamplerEnd(this);
            }
            if (this.rampDownTime > 0L) {
                try {
                    Thread.sleep(this.rampDownTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.log.debug("Ramp down end");
            this.onRampDownEnd();
            if (this.perfEventListener != null) {
                this.perfEventListener.onRampDownEnd(this);
            }
        }
        finally {
            this.completionLatch.countDown();
        }
    }

    protected void sample() {
        while (this.isRunning.get()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.sampleData();
            ++this.sampleIndex;
        }
    }

    @Override
    public abstract void sampleData();

    protected void onRampUpStart() {
    }

    protected void onSamplerStart() {
    }

    protected void onSamplerEnd() {
    }

    protected void onRampDownEnd() {
    }
}

