/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.reports;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.activemq.tool.reports.AbstractPerfReportWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFilePerfReportWriter
extends AbstractPerfReportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFilePerfReportWriter.class);
    private File tempLogFile;
    private PrintWriter tempLogFileWriter;
    private File xmlFile;
    private PrintWriter xmlFileWriter;
    private String reportDir;
    private String reportName;
    private Map<String, Properties> testPropsMap = new HashMap<String, Properties>();
    private List<Properties> testPropsList = new ArrayList<Properties>();

    public XmlFilePerfReportWriter() {
        this("", "PerformanceReport.xml");
    }

    public XmlFilePerfReportWriter(String reportDir, String reportName) {
        this.reportDir = reportDir;
        this.reportName = reportName;
    }

    @Override
    public void openReportWriter() {
        if (this.tempLogFile == null) {
            this.tempLogFile = this.createTempLogFile();
        }
        try {
            this.tempLogFileWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.tempLogFile), 102400), false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeReportWriter() {
        this.tempLogFileWriter.flush();
        this.tempLogFileWriter.close();
        this.writeToXml();
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    @Override
    public void writeInfo(String info) {
        this.tempLogFileWriter.println("[INFO]" + info);
    }

    @Override
    public void writeCsvData(int csvType, String csvData) {
        if (csvType == 0) {
            this.tempLogFileWriter.println("[TP-DATA]" + csvData);
        } else if (csvType == 1) {
            this.tempLogFileWriter.println("[CPU-DATA]" + csvData);
        }
    }

    @Override
    public void writeProperties(String header, Properties props) {
        this.testPropsMap.put(header, props);
    }

    @Override
    public void writeProperties(Properties props) {
        this.testPropsList.add(props);
    }

    protected File createTempLogFile() {
        File f;
        try {
            f = File.createTempFile("tmpPL", null);
        }
        catch (IOException e) {
            f = new File("tmpPL" + System.currentTimeMillis() + ".tmp");
        }
        f.deleteOnExit();
        return f;
    }

    protected File createXmlFile() {
        Object filename = this.getReportName().endsWith(".xml") ? this.getReportName() : this.getReportName() + ".xml";
        String path = this.getReportDir() == null ? "" : this.getReportDir();
        return new File(path + (String)filename);
    }

    protected void writeToXml() {
        try {
            this.xmlFile = this.createXmlFile();
            this.xmlFileWriter = new PrintWriter(new FileOutputStream(this.xmlFile));
            this.writeXmlHeader();
            this.writeXmlTestSettings();
            this.writeXmlLogFile();
            this.writeXmlPerfSummary();
            this.writeXmlFooter();
            this.xmlFileWriter.close();
            LOG.info("Created performance report: " + this.xmlFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeXmlHeader() {
        this.xmlFileWriter.println("<testResult>");
    }

    protected void writeXmlFooter() {
        this.xmlFileWriter.println("</testResult>");
    }

    protected void writeXmlTestSettings() {
        for (String key : this.testPropsMap.keySet()) {
            Properties props = this.testPropsMap.get(key);
            this.writeMap(key, props);
        }
        int count = 1;
        for (Properties props : this.testPropsList) {
            this.writeMap("settings" + count++, props);
        }
    }

    protected void writeXmlLogFile() throws IOException {
        this.xmlFileWriter.println("<property name='performanceData'>");
        this.xmlFileWriter.println("<list>");
        try (FileInputStream fileInputStream = new FileInputStream(this.tempLogFile);
             InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("[TP-DATA]")) {
                    this.handleCsvData(0, line.substring("[TP-DATA]".length()));
                    this.parsePerfCsvData("tpdata", line.substring("[TP-DATA]".length()));
                    continue;
                }
                if (line.startsWith("[CPU-DATA]")) {
                    this.handleCsvData(1, line.substring("[CPU-DATA]".length()));
                    this.parsePerfCsvData("cpudata", line.substring("[CPU-DATA]".length()));
                    continue;
                }
                if (line.startsWith("[INFO]")) {
                    this.xmlFileWriter.println("<info>" + line + "</info>");
                    continue;
                }
                this.xmlFileWriter.println("<error>" + line + "</error>");
            }
        }
        this.xmlFileWriter.println("</list>");
        this.xmlFileWriter.println("</property>");
    }

    protected void writeXmlPerfSummary() {
        Map summary = this.getSummary(0);
        if (summary != null && summary.size() > 0) {
            this.writeThroughputSummary(summary);
        }
        if ((summary = this.getSummary(1)) != null && summary.size() > 0) {
            this.writeCpuSummary(summary);
        }
    }

    protected void writeThroughputSummary(Map summary) {
        this.xmlFileWriter.println("<property name='perfTpSummary'>");
        this.xmlFileWriter.println("<props>");
        System.out.println("#########################################");
        System.out.println("####    SYSTEM THROUGHPUT SUMMARY    ####");
        System.out.println("#########################################");
        String val = (String)summary.get("SystemTotalTP");
        System.out.println("System Total Throughput: " + val);
        this.xmlFileWriter.println("<prop key='SystemTotalTP'>" + val + "</prop>");
        val = (String)summary.get("SystemTotalClients");
        System.out.println("System Total Clients: " + val);
        this.xmlFileWriter.println("<prop key='SystemTotalClients'>" + val + "</prop>");
        val = (String)summary.get("SystemAveTP");
        System.out.println("System Average Throughput: " + val);
        this.xmlFileWriter.println("<prop key='SystemAveTP'>" + val + "</prop>");
        val = (String)summary.get("SystemAveEMMTP");
        System.out.println("System Average Throughput Excluding Min/Max: " + val);
        this.xmlFileWriter.println("<prop key='SystemAveEMMTP'>" + val + "</prop>");
        val = (String)summary.get("SystemAveClientTP");
        System.out.println("System Average Client Throughput: " + val);
        this.xmlFileWriter.println("<prop key='SystemAveClientTP'>" + val + "</prop>");
        val = (String)summary.get("SystemAveClientEMMTP");
        System.out.println("System Average Client Throughput Excluding Min/Max: " + val);
        this.xmlFileWriter.println("<prop key='SystemAveClientEMMTP'>" + val + "</prop>");
        val = (String)summary.get("MinClientTP");
        String clientName = val.substring(0, val.indexOf("="));
        String clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Min Client Throughput Per Sample: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MinClientTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        val = (String)summary.get("MaxClientTP");
        clientName = val.substring(0, val.indexOf("="));
        clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Max Client Throughput Per Sample: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MaxClientTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        val = (String)summary.get("MinClientTotalTP");
        clientName = val.substring(0, val.indexOf("="));
        clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Min Client Total Throughput: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MinClientTotalTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        val = (String)summary.get("MaxClientTotalTP");
        clientName = val.substring(0, val.indexOf("="));
        clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Max Client Total Throughput: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MaxClientTotalTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        val = (String)summary.get("MinClientAveTP");
        clientName = val.substring(0, val.indexOf("="));
        clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Min Average Client Throughput: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MinClientAveTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        val = (String)summary.get("MaxClientAveTP");
        clientName = val.substring(0, val.indexOf("="));
        clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Max Average Client Throughput: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MaxClientAveTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        val = (String)summary.get("MinClientAveEMMTP");
        clientName = val.substring(0, val.indexOf("="));
        clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Min Average Client Throughput Excluding Min/Max: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MinClientAveEMMTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        val = (String)summary.get("MaxClientAveEMMTP");
        clientName = val.substring(0, val.indexOf("="));
        clientVal = val.substring(val.indexOf("=") + 1);
        System.out.println("Max Average Client Throughput Excluding Min/Max: clientName=" + clientName + ", value=" + clientVal);
        this.xmlFileWriter.println("<prop key='MaxClientAveEMMTP'>clientName=" + clientName + ",value=" + clientVal + "</prop>");
        this.xmlFileWriter.println("</props>");
        this.xmlFileWriter.println("</property>");
    }

    protected void writeCpuSummary(Map summary) {
        this.xmlFileWriter.println("<property name='perfTpSummary'>");
        this.xmlFileWriter.println("<props>");
        System.out.println("########################################");
        System.out.println("####    SYSTEM CPU USAGE SUMMARY    ####");
        System.out.println("########################################");
        this.xmlFileWriter.println("<prop key='BlocksReceived'>" + summary.get("BlocksReceived") + "</prop>");
        System.out.println("Total Blocks Received: " + summary.get("BlocksReceived"));
        this.xmlFileWriter.println("<prop key='AveBlocksReceived'>" + summary.get("AveBlocksReceived") + "</prop>");
        System.out.println("Ave Blocks Received: " + summary.get("AveBlocksReceived"));
        this.xmlFileWriter.println("<prop key='BlocksSent'>" + summary.get("BlocksSent") + "</prop>");
        System.out.println("Total Blocks Sent: " + summary.get("BlocksSent"));
        this.xmlFileWriter.println("<prop key='AveBlocksSent'>" + summary.get("AveBlocksSent") + "</prop>");
        System.out.println("Ave Blocks Sent: " + summary.get("AveBlocksSent"));
        this.xmlFileWriter.println("<prop key='ContextSwitches'>" + summary.get("ContextSwitches") + "</prop>");
        System.out.println("Total Context Switches: " + summary.get("ContextSwitches"));
        this.xmlFileWriter.println("<prop key='AveContextSwitches'>" + summary.get("AveContextSwitches") + "</prop>");
        System.out.println("Ave Context Switches: " + summary.get("AveContextSwitches"));
        this.xmlFileWriter.println("<prop key='UserTime'>" + summary.get("UserTime") + "</prop>");
        System.out.println("Total User Time: " + summary.get("UserTime"));
        this.xmlFileWriter.println("<prop key='AveUserTime'>" + summary.get("AveUserTime") + "</prop>");
        System.out.println("Ave User Time: " + summary.get("AveUserTime"));
        this.xmlFileWriter.println("<prop key='SystemTime'>" + summary.get("SystemTime") + "</prop>");
        System.out.println("Total System Time: " + summary.get("SystemTime"));
        this.xmlFileWriter.println("<prop key='AveSystemTime'>" + summary.get("AveSystemTime") + "</prop>");
        System.out.println("Ave System Time: " + summary.get("AveSystemTime"));
        this.xmlFileWriter.println("<prop key='IdleTime'>" + summary.get("IdleTime") + "</prop>");
        System.out.println("Total Idle Time: " + summary.get("IdleTime"));
        this.xmlFileWriter.println("<prop key='AveIdleTime'>" + summary.get("AveIdleTime") + "</prop>");
        System.out.println("Ave Idle Time: " + summary.get("AveIdleTime"));
        this.xmlFileWriter.println("<prop key='WaitingTime'>" + summary.get("WaitingTime") + "</prop>");
        System.out.println("Total Wait Time: " + summary.get("WaitingTime"));
        this.xmlFileWriter.println("<prop key='AveWaitingTime'>" + summary.get("AveWaitingTime") + "</prop>");
        System.out.println("Ave Wait Time: " + summary.get("AveWaitingTime"));
        this.xmlFileWriter.println("</props>");
        this.xmlFileWriter.println("</property>");
    }

    protected void writeMap(String name, Map map) {
        this.xmlFileWriter.println("<property name='" + name + "'>");
        this.xmlFileWriter.println("<props>");
        for (String propKey : map.keySet()) {
            Object propVal = map.get(propKey);
            this.xmlFileWriter.println("<prop key='" + propKey + "'>" + propVal.toString() + "</prop>");
        }
        this.xmlFileWriter.println("</props>");
        this.xmlFileWriter.println("</property>");
    }

    protected void parsePerfCsvData(String elementName, String csvData) {
        StringTokenizer tokenizer = new StringTokenizer(csvData, ",;");
        String xmlElement = "<" + elementName;
        while (tokenizer.hasMoreTokens()) {
            String data = tokenizer.nextToken();
            String key = data.substring(0, data.indexOf("="));
            String val = data.substring(data.indexOf("=") + 1);
            xmlElement = xmlElement + " " + key + "='" + val + "'";
        }
        xmlElement = xmlElement + " />";
        this.xmlFileWriter.println(xmlElement);
    }
}

