/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;

public class MemProducer {
    protected Connection connection;
    protected MessageProducer producer;

    public MemProducer(ConnectionFactory fac, Destination dest) throws JMSException {
        this.connection = fac.createConnection();
        Session s = this.connection.createSession(false, 1);
        this.producer = s.createProducer(dest);
    }

    public void setDeliveryMode(int mode) throws JMSException {
        this.producer.setDeliveryMode(mode);
    }

    public void start() throws JMSException {
        this.connection.start();
    }

    public void stop() throws JMSException {
        this.connection.stop();
    }

    public void shutDown() throws JMSException {
        this.connection.close();
    }

    public void sendMessage(Message msg) throws JMSException {
        this.sendMessage(msg, null, 0L);
    }

    public void sendMessage(Message msg, String headerName, long headerValue) throws JMSException {
        if (headerName != null) {
            msg.setLongProperty(headerName, headerValue);
        }
        this.producer.send(msg);
    }
}

