/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.junit;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.junit.Repeat;
import org.apache.activemq.junit.RepeatStatement;
import org.junit.Test;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQTestRunner.class);

    public ActiveMQTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Statement statement = super.methodBlock(method);
        statement = this.withPotentialRepeat(method, statement);
        return statement;
    }

    protected Statement withPotentialTimeout(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        long testTimeout = this.getOriginalTimeout(frameworkMethod);
        if (testTimeout > 0L) {
            String multiplierString = System.getProperty("org.apache.activemq.junit.testTimeoutMultiplier");
            double multiplier = 0.0;
            try {
                multiplier = Double.parseDouble(multiplierString);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Ignoring testTimeoutMultiplier not set to a valid value: " + multiplierString);
            }
            if (multiplier > 0.0) {
                LOG.info("Test timeout multiple {} applied to test timeout {}ms: new timeout = {}", new Object[]{multiplier, testTimeout, (long)((double)testTimeout * multiplier)});
                testTimeout = (long)((double)testTimeout * multiplier);
            }
            next = FailOnTimeout.builder().withTimeout(testTimeout, TimeUnit.MILLISECONDS).build(next);
        } else {
            next = super.withPotentialTimeout(frameworkMethod, testInstance, next);
        }
        return next;
    }

    protected Statement withPotentialRepeat(FrameworkMethod frameworkMethod, Statement next) {
        Repeat repeatAnnotation = (Repeat)frameworkMethod.getAnnotation(Repeat.class);
        if (repeatAnnotation != null) {
            next = RepeatStatement.builder().build(repeatAnnotation, next);
        }
        return next;
    }

    protected long getOriginalTimeout(FrameworkMethod frameworkMethod) {
        Test test = (Test)frameworkMethod.getAnnotation(Test.class);
        return test != null && test.timeout() > 0L ? test.timeout() : 0L;
    }
}

