/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.activemq.artemis.tests.extensions.CleanupSystemPropertiesExtension;
import org.apache.activemq.artemis.tests.extensions.FilesLeftBehindCheckExtension;
import org.apache.activemq.artemis.tests.extensions.LogTestNameExtension;
import org.apache.activemq.artemis.tests.extensions.OpenFilesCheckExtension;
import org.apache.activemq.artemis.tests.extensions.ThreadLeakCheckExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extensions(value={@ExtendWith(value={LogTestNameExtension.class}), @ExtendWith(value={CleanupSystemPropertiesExtension.class})})
public abstract class ArtemisTestCase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @RegisterExtension
    protected static ThreadLeakCheckExtension threadLeakCheckExtension = new ThreadLeakCheckExtension();
    @RegisterExtension
    protected static OpenFilesCheckExtension openFilesCheckExtension = new OpenFilesCheckExtension(1000L);
    @RegisterExtension
    protected static FilesLeftBehindCheckExtension filesLeftBehindCheckExtension = new FilesLeftBehindCheckExtension("data", "null");
    private static String testClassName = "not-yet-set";
    public String name;
    private List<TestCompletionTask> runAfter;

    protected void runAfter(TestCompletionTask completionTask) {
        Assertions.assertNotNull((Object)completionTask);
        this.runAfterEx(() -> {
            try {
                completionTask.run();
            }
            catch (Throwable e) {
                logger.warn("Lambda {} is throwing an exception", (Object)completionTask.toString(), (Object)e);
            }
        });
    }

    protected synchronized void runAfterEx(TestCompletionTask completionTask) {
        Assertions.assertNotNull((Object)completionTask);
        if (this.runAfter == null) {
            this.runAfter = new ArrayList<TestCompletionTask>();
        }
        this.runAfter.add(completionTask);
    }

    @BeforeAll
    public static void doBeforeTestClass(TestInfo testInfo) {
        testClassName = ((Class)testInfo.getTestClass().get()).getName();
    }

    @BeforeEach
    public void doBeforeTestMethod(TestInfo testInfo) {
        this.name = ((Method)testInfo.getTestMethod().get()).getName();
    }

    @AfterEach
    public synchronized void doRunAfter() throws Throwable {
        ArrayList throwables = new ArrayList();
        List<TestCompletionTask> localRunAfter = this.runAfter;
        this.runAfter = null;
        if (localRunAfter != null) {
            localRunAfter.forEach(r -> {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                    throwables.add(e);
                }
            });
        }
        if (!throwables.isEmpty()) {
            throw (Throwable)throwables.get(0);
        }
    }

    public static void forceGC() {
        ThreadLeakCheckExtension.forceGC();
    }

    public MBeanServer createMBeanServer() {
        MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer();
        this.runAfter(() -> MBeanServerFactory.releaseMBeanServer(mBeanServer));
        return mBeanServer;
    }

    public String getTestMethodName() {
        return this.name;
    }

    public static String getTestClassName() {
        return testClassName;
    }

    public static interface TestCompletionTask {
        public void run() throws Exception;
    }
}

