/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTestNameExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
TestWatcher,
Extension {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean parameterizedTestClass = false;

    public void beforeAll(ExtensionContext context) throws Exception {
        List parameterProviders = AnnotationSupport.findAnnotatedMethods((Class)context.getRequiredTestClass(), Parameters.class, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        this.parameterizedTestClass = !parameterProviders.isEmpty();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        String testClass = context.getRequiredTestClass().getSimpleName();
        String testMethod = context.getRequiredTestMethod().getName();
        if (this.parameterizedTestClass) {
            logger.info("*** start test {} {}() {} ***", new Object[]{testClass, testMethod, context.getDisplayName()});
        } else {
            logger.info("*** start test {} {}() ***", (Object)testClass, (Object)testMethod);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        String testClass = context.getRequiredTestClass().getSimpleName();
        String testMethod = context.getRequiredTestMethod().getName();
        if (this.parameterizedTestClass) {
            logger.info("*** end test {} {}() {} ***", new Object[]{testClass, testMethod, context.getDisplayName()});
        } else {
            logger.info("*** end test {} {}() ***", (Object)testClass, (Object)testMethod);
        }
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        String testMethod = context.getRequiredTestMethod().getName();
        if (this.parameterizedTestClass) {
            logger.error("### Failure in test {}() {} ###", (Object)testMethod, (Object)context.getDisplayName());
        } else {
            logger.error("### Failure in test {}() ###", (Object)testMethod);
        }
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        String testMethod = context.getRequiredTestMethod().getName();
        if (this.parameterizedTestClass) {
            logger.error("### Aborted test {}() {} ###", (Object)testMethod, (Object)context.getDisplayName());
        } else {
            logger.error("### Aborted test {}() ###", (Object)testMethod);
        }
    }
}

