/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.lang.invoke.MethodHandles;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSupportUtil {
    private static Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String EXPECTED_DERBY_DROP_STATE = "08006";
    public static final String EXPECTED_DERBY_SHUTDOWN_STATE = "XJ015";

    public static void dropDerbyDatabase(String user, String password, String databaseName) throws SQLException {
        try {
            if (user == null) {
                DriverManager.getConnection("jdbc:derby:" + databaseName + ";drop=true");
            } else {
                DriverManager.getConnection("jdbc:derby:" + databaseName + ";drop=true", user, password);
            }
        }
        catch (SQLException sqlE) {
            if (!sqlE.getSQLState().equals(EXPECTED_DERBY_DROP_STATE)) {
                logger.warn("{} / {}", (Object)sqlE.getMessage(), (Object)sqlE.getSQLState());
                throw sqlE;
            }
            logger.info("{} / {}", (Object)sqlE.getMessage(), (Object)sqlE.getSQLState());
        }
    }

    public static void shutdownDerby(String user, String password) throws SQLException {
        block4: {
            try {
                if (user == null) {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true;deregister=false");
                } else {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true;deregister=false", user, password);
                }
            }
            catch (SQLException sqlE) {
                logger.debug("{} / {}", (Object)sqlE.getMessage(), (Object)sqlE.getSQLState());
                if (sqlE.getSQLState().equals(EXPECTED_DERBY_SHUTDOWN_STATE)) break block4;
                throw sqlE;
            }
        }
    }
}

