/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFilesCheckExtension
implements Extension,
AfterAllCallback {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    private long maxFiles;

    public OpenFilesCheckExtension(long maxFiles) {
        this.maxFiles = maxFiles;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        String testName = context.getRequiredTestClass().getName();
        logger.debug("Checking open files after {}", (Object)testName);
        if (!Wait.waitFor(() -> OpenFilesCheckExtension.getOpenFD() < this.maxFiles, 10000L, 0L)) {
            String fileList = this.getOpenList();
            Assertions.fail((String)("Too many files open (" + OpenFilesCheckExtension.getOpenFD() + ">" + this.maxFiles + ") after " + testName + ". A possible list: " + fileList));
        }
    }

    public static long getOpenFD() {
        OperatingSystemMXBean operatingSystemMXBean = os;
        if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean bean = (UnixOperatingSystemMXBean)operatingSystemMXBean;
            return bean.getOpenFileDescriptorCount();
        }
        return 0L;
    }

    public static List<String> getOpenFiles(boolean filtered) {
        ArrayList<String> openFiles = new ArrayList<String>();
        try {
            int processId = OpenFilesCheckExtension.getProcessId();
            Process child = Runtime.getRuntime().exec("lsof -a -p " + processId + " -d ^txt,^mem,^cwd,^rtd,^DEL", new String[0]);
            try (BufferedReader processInput = new BufferedReader(new InputStreamReader(child.getInputStream()));){
                String outputLine;
                processInput.readLine();
                while ((outputLine = processInput.readLine()) != null) {
                    if (filtered && (outputLine.endsWith(".jar") || outputLine.endsWith(".so") || outputLine.contains("type=STREAM"))) continue;
                    openFiles.add(outputLine);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return openFiles;
    }

    private static int getProcessId() throws ReflectiveOperationException {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        Field jvmField = runtime.getClass().getDeclaredField("jvm");
        jvmField.setAccessible(true);
        Object jvm = jvmField.get(runtime);
        Method getProcessIdMethod = jvm.getClass().getDeclaredMethod("getProcessId", new Class[0]);
        getProcessIdMethod.setAccessible(true);
        return (Integer)getProcessIdMethod.invoke(jvm, new Object[0]);
    }

    private String getOpenList() {
        List<String> openFiles = OpenFilesCheckExtension.getOpenFiles(true);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        boolean first = true;
        for (String str : openFiles) {
            if (!first) {
                printWriter.print("\n");
            }
            first = false;
            printWriter.print(str);
        }
        return stringWriter.toString();
    }
}

