/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp.v10;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.FrameEventListener;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompDecoder;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompVersions;
import org.apache.activemq.artemis.core.protocol.stomp.VersionedStompFrameHandler;
import org.apache.activemq.artemis.core.protocol.stomp.v10.StompFrameV10;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class StompFrameHandlerV10
extends VersionedStompFrameHandler
implements FrameEventListener {
    public StompFrameHandlerV10(StompConnection connection, ScheduledExecutorService scheduledExecutorService, ExecutorFactory factory) {
        super(connection, scheduledExecutorService, factory);
        this.decoder = new StompDecoder(this);
        this.decoder.init();
        connection.addStompEventListener(this);
    }

    @Override
    public StompFrame onConnect(StompFrame frame) {
        StompFrameV10 response = null;
        Map<String, String> headers = frame.getHeadersMap();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientID = headers.get("client-id");
        String requestID = headers.get("request-id");
        if (this.connection.validateUser(login, passcode, this.connection)) {
            this.connection.setClientID(clientID);
            this.connection.setValid(true);
            response = new StompFrameV10("CONNECTED");
            if (frame.hasHeader("accept-version")) {
                response.addHeader("version", StompVersions.V1_0.toString());
            }
            response.addHeader("session", this.connection.getID().toString());
            if (requestID != null) {
                response.addHeader("response-id", requestID);
            }
        } else {
            response = new StompFrameV10("ERROR");
            String responseText = "Security Error occurred: User name [" + login + "] or password is invalid";
            response.setBody(responseText);
            response.addHeader("message", responseText);
        }
        return response;
    }

    @Override
    public StompFrame onDisconnect(StompFrame frame) {
        return null;
    }

    @Override
    public StompFrame onUnsubscribe(StompFrame request) {
        StompFrame response = null;
        String destination = request.getHeader("destination");
        String id = request.getHeader("id");
        String durableSubscriptionName = request.getHeader("durable-subscriber-name");
        if (durableSubscriptionName == null) {
            durableSubscriptionName = request.getHeader("durable-subscription-name");
        }
        String subscriptionID = null;
        if (id != null) {
            subscriptionID = id;
        } else {
            if (destination == null) {
                ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.needIDorDestination().setHandler(this);
                response = error.getFrame();
                return response;
            }
            subscriptionID = "subscription/" + destination;
        }
        try {
            this.connection.unsubscribe(subscriptionID, durableSubscriptionName);
        }
        catch (ActiveMQStompException e) {
            return e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onAck(StompFrame request) {
        StompFrame response = null;
        String messageID = request.getHeader("message-id");
        String txID = request.getHeader("transaction");
        if (txID != null) {
            ActiveMQServerLogger.LOGGER.stompTXAckNorSupported();
        }
        try {
            this.connection.acknowledge(messageID, null);
        }
        catch (ActiveMQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onStomp(StompFrame request) {
        return this.onUnknown(request.getCommand());
    }

    @Override
    public StompFrame onNack(StompFrame request) {
        return this.onUnknown(request.getCommand());
    }

    @Override
    public StompFrame createStompFrame(String command) {
        return new StompFrameV10(command);
    }

    @Override
    public void replySent(StompFrame reply) {
        if (reply.needsDisconnect()) {
            this.connection.destroy();
        }
    }

    @Override
    public void requestAccepted(StompFrame request) {
    }
}

