/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.reader.MessageUtil;

public class StompUtils {
    private static final String DEFAULT_MESSAGE_PRIORITY = "4";

    public static void copyStandardHeadersFromFrameToMessage(StompFrame frame, Message msg, String prefix) throws Exception {
        long deliveryTime;
        String scheduledTime;
        long delay;
        String scheduledDelay;
        String expiration;
        Object replyTo;
        String contentType;
        String groupID;
        String type;
        String correlationID;
        HashMap<String, String> headers = new HashMap<String, String>(frame.getHeadersMap());
        String priority = (String)headers.remove("priority");
        if (priority != null) {
            msg.setPriority(Byte.parseByte(priority));
        } else {
            msg.setPriority(Byte.parseByte(DEFAULT_MESSAGE_PRIORITY));
        }
        String persistent = (String)headers.remove("persistent");
        if (persistent != null) {
            msg.setDurable(Boolean.parseBoolean(persistent));
        }
        if ((correlationID = (String)headers.remove("correlation-id")) != null) {
            msg.putObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME, (Object)correlationID);
        }
        if ((type = (String)headers.remove("type")) != null) {
            msg.putObjectProperty(MessageUtil.TYPE_HEADER_NAME, (Object)type);
        }
        if ((groupID = (String)headers.remove("JMSXGroupID")) != null) {
            msg.putStringProperty(Message.HDR_GROUP_ID, SimpleString.toSimpleString((String)groupID));
        }
        if ((contentType = (String)headers.remove("content-type")) != null) {
            msg.putStringProperty(Message.HDR_CONTENT_TYPE, SimpleString.toSimpleString((String)contentType));
        }
        if ((replyTo = headers.remove("reply-to")) != null) {
            msg.putStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME, SimpleString.toSimpleString((String)((String)replyTo)));
        }
        if ((expiration = (String)headers.remove("expires")) != null) {
            msg.setExpiration(Long.parseLong(expiration));
        }
        if ((scheduledDelay = (String)headers.remove("AMQ_SCHEDULED_DELAY")) != null && (delay = Long.parseLong(scheduledDelay)) > 0L) {
            msg.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, System.currentTimeMillis() + delay);
        }
        if ((scheduledTime = (String)headers.remove("AMQ_SCHEDULED_TIME")) != null && (deliveryTime = Long.parseLong(scheduledTime)) > 0L) {
            msg.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, deliveryTime);
        }
        if (prefix != null) {
            msg.putStringProperty(Message.HDR_PREFIX, prefix);
        }
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            msg.putObjectProperty(name, value);
        }
    }

    public static void copyStandardHeadersFromMessageToFrame(Message message, StompFrame command, int deliveryCount) {
        SimpleString prefix = message.getSimpleStringProperty(Message.HDR_PREFIX);
        command.addHeader("destination", (Serializable)((Object)(prefix == null ? "" : prefix)) + message.getAddress());
        if (message.getObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME) != null) {
            command.addHeader("correlation-id", message.getObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME).toString());
        }
        command.addHeader("expires", "" + message.getExpiration());
        command.addHeader("redelivered", String.valueOf(deliveryCount > 1));
        command.addHeader("priority", "" + message.getPriority());
        command.addHeader("persistent", "" + message.isDurable());
        if (message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME) != null) {
            command.addHeader("reply-to", message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME));
        }
        command.addHeader("timestamp", "" + message.getTimestamp());
        if (message.getObjectProperty(MessageUtil.TYPE_HEADER_NAME) != null) {
            command.addHeader("type", message.getObjectProperty(MessageUtil.TYPE_HEADER_NAME).toString());
        }
        if (message.getStringProperty(Message.HDR_CONTENT_TYPE.toString()) != null) {
            command.addHeader("content-type", message.getStringProperty(Message.HDR_CONTENT_TYPE.toString()));
        }
        if (message.getValidatedUserID() != null) {
            command.addHeader("JMSXUserID", message.getValidatedUserID());
        }
        if (message.containsProperty(Message.HDR_ROUTING_TYPE)) {
            command.addHeader("destination-type", RoutingType.getType((byte)message.getByteProperty(Message.HDR_ROUTING_TYPE.toString())).toString());
        }
        if (message.containsProperty(Message.HDR_INGRESS_TIMESTAMP)) {
            command.addHeader("ingress-timestamp", Long.toString(message.getLongProperty(Message.HDR_INGRESS_TIMESTAMP)));
        }
        Set names = message.getPropertyNames();
        for (SimpleString name : names) {
            if (name.equals((Object)ClientMessageImpl.REPLYTO_HEADER_NAME) || name.equals((Object)Message.HDR_CONTENT_TYPE) || name.equals((Object)Message.HDR_VALIDATED_USER) || name.equals((Object)Message.HDR_ROUTING_TYPE) || name.equals((Object)Message.HDR_PREFIX) || name.equals((Object)MessageUtil.TYPE_HEADER_NAME) || name.equals((Object)MessageUtil.CORRELATIONID_HEADER_NAME) || name.toString().equals("destination")) continue;
            Object value = message.getObjectProperty(name);
            if (value != null) {
                command.addHeader(name.toString(), value.toString());
                continue;
            }
            command.addHeader(name.toString(), "");
        }
    }
}

