/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class JMXAccessControlList {
    private Access defaultAccess = new Access("*");
    private Map<String, Access> domainAccess = new HashMap<String, Access>();
    private ConcurrentHashMap<String, List<String>> whitelist = new ConcurrentHashMap();

    public void addToWhiteList(String domain, String match) {
        List<Object> list = new ArrayList();
        if ((list = (List)this.whitelist.putIfAbsent(domain, list)) == null) {
            list = this.whitelist.get(domain);
        }
        list.add(match != null ? match : "*");
    }

    public List<String> getRolesForObject(ObjectName objectName, String methodName) {
        Access access;
        String key;
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        for (Map.Entry<String, String> keyEntry : keyPropertyList.entrySet()) {
            key = keyEntry.getKey() + "=" + keyEntry.getValue();
            access = this.domainAccess.get(this.getObjectID(objectName.getDomain(), key));
            if (access == null) continue;
            return access.getMatchingRolesForMethod(methodName);
        }
        for (Map.Entry<String, String> keyEntry : keyPropertyList.entrySet()) {
            key = keyEntry.getKey() + "=*";
            access = this.domainAccess.get(this.getObjectID(objectName.getDomain(), key));
            if (access == null) continue;
            return access.getMatchingRolesForMethod(methodName);
        }
        Access access2 = this.domainAccess.get(objectName.getDomain());
        if (access2 == null) {
            access2 = this.defaultAccess;
        }
        return access2.getMatchingRolesForMethod(methodName);
    }

    public boolean isInWhiteList(ObjectName objectName) {
        List<String> matches = this.whitelist.get(objectName.getDomain());
        if (matches != null) {
            for (String match : matches) {
                if (match.equals("*")) {
                    return true;
                }
                String[] split = match.split("=");
                String key = split[0];
                String val = split[1];
                String propVal = objectName.getKeyProperty(key);
                if (propVal == null || !val.equals("*") && !propVal.equals(val)) continue;
                return true;
            }
        }
        return false;
    }

    public void addToDefaultAccess(String method, String ... roles) {
        if (roles != null) {
            if (method.equals("*")) {
                this.defaultAccess.addCatchAll(roles);
            } else if (method.endsWith("*")) {
                String prefix = method.replace("*", "");
                this.defaultAccess.addMethodsPrefixes(prefix, roles);
            } else {
                this.defaultAccess.addMethods(method, roles);
            }
        }
    }

    public void addToRoleAccess(String domain, String key, String method, String ... roles) {
        String id = this.getObjectID(domain, key);
        Access access = this.domainAccess.get(id);
        if (access == null) {
            access = new Access(domain);
            this.domainAccess.put(id, access);
        }
        if (method.endsWith("*")) {
            String prefix = method.replace("*", "");
            access.addMethodsPrefixes(prefix, roles);
        } else {
            access.addMethods(method, roles);
        }
    }

    private String getObjectID(String domain, String key) {
        String id = domain;
        if (key != null) {
            String actualKey = key;
            if (key.endsWith("\"")) {
                actualKey = actualKey.replace("\"", "");
            }
            id = id + ":" + actualKey;
        }
        return id;
    }

    public static JMXAccessControlList createDefaultList() {
        JMXAccessControlList accessControlList = new JMXAccessControlList();
        accessControlList.addToWhiteList("hawtio", "type=*");
        accessControlList.addToRoleAccess("org.apache.activemq.apache", null, "list*", "view", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.apache", null, "get*", "view", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.apache", null, "is*", "view", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.apache", null, "set*", "update", "amq");
        accessControlList.addToRoleAccess("org.apache.activemq.apache", null, "*", "amq");
        accessControlList.addToDefaultAccess("list*", "view", "update", "amq");
        accessControlList.addToDefaultAccess("get*", "view", "update", "amq");
        accessControlList.addToDefaultAccess("is*", "view", "update", "amq");
        accessControlList.addToDefaultAccess("set*", "update", "amq");
        accessControlList.addToDefaultAccess("*", "amq");
        return accessControlList;
    }

    static class Access {
        private final String domain;
        List<String> catchAllRoles = new ArrayList<String>();
        Map<String, List<String>> methodRoles = new HashMap<String, List<String>>();
        Map<String, List<String>> methodPrefixRoles = new HashMap<String, List<String>>();

        Access(String domain) {
            this.domain = domain;
        }

        public synchronized void addMethods(String prefix, String ... roles) {
            List<String> rolesList = this.methodRoles.get(prefix);
            if (rolesList == null) {
                rolesList = new ArrayList<String>();
                this.methodRoles.put(prefix, rolesList);
            }
            for (String role : roles) {
                rolesList.add(role);
            }
        }

        public synchronized void addMethodsPrefixes(String prefix, String ... roles) {
            List<String> rolesList = this.methodPrefixRoles.get(prefix);
            if (rolesList == null) {
                rolesList = new ArrayList<String>();
                this.methodPrefixRoles.put(prefix, rolesList);
            }
            for (String role : roles) {
                rolesList.add(role);
            }
        }

        public void addCatchAll(String ... roles) {
            for (String role : roles) {
                this.catchAllRoles.add(role);
            }
        }

        public String getDomain() {
            return this.domain;
        }

        public List<String> getMatchingRolesForMethod(String methodName) {
            List<String> roles = this.methodRoles.get(methodName);
            if (roles != null) {
                return roles;
            }
            for (Map.Entry<String, List<String>> entry : this.methodPrefixRoles.entrySet()) {
                if (!methodName.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
            return this.catchAllRoles;
        }
    }
}

