/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.ScheduledLeaseLock;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;

final class ActiveMQScheduledLeaseLock
extends ActiveMQScheduledComponent
implements ScheduledLeaseLock {
    private static final Logger LOGGER = Logger.getLogger(ActiveMQScheduledLeaseLock.class);
    private final String lockName;
    private final LeaseLock lock;
    private long lastLockRenewStart;
    private final long renewPeriodMillis;
    private final IOCriticalErrorListener ioCriticalErrorListener;

    ActiveMQScheduledLeaseLock(ScheduledExecutorService scheduledExecutorService, ArtemisExecutor executor, String lockName, LeaseLock lock, long renewPeriodMillis, IOCriticalErrorListener ioCriticalErrorListener) {
        super(scheduledExecutorService, (Executor)executor, 0L, renewPeriodMillis, TimeUnit.MILLISECONDS, false);
        if (renewPeriodMillis >= lock.expirationMillis()) {
            throw new IllegalArgumentException("renewPeriodMillis must be < lock's expirationMillis");
        }
        this.lockName = lockName;
        this.lock = lock;
        this.renewPeriodMillis = renewPeriodMillis;
        this.lastLockRenewStart = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(lock.expirationMillis());
        this.ioCriticalErrorListener = ioCriticalErrorListener;
    }

    @Override
    public long renewPeriodMillis() {
        return this.renewPeriodMillis;
    }

    @Override
    public LeaseLock lock() {
        return this.lock;
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        this.lastLockRenewStart = System.nanoTime();
        super.start();
    }

    public synchronized void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
    }

    public void run() {
        long lastRenewStart = this.lastLockRenewStart;
        long renewStart = System.nanoTime();
        if (!this.lock.renew()) {
            this.ioCriticalErrorListener.onIOException((Throwable)new IllegalStateException(this.lockName + " lock can't be renewed"), "Critical error while on " + this.lockName + " renew", null);
        }
        ActiveMQScheduledLeaseLock.detectAndReportRenewSlowness(this.lockName, lastRenewStart, renewStart, this.renewPeriodMillis, this.lock.expirationMillis());
        this.lastLockRenewStart = renewStart;
    }

    private static void detectAndReportRenewSlowness(String lockName, long lastRenewStart, long renewStart, long expectedRenewPeriodMillis, long expirationMillis) {
        long measuredRenewPeriodNanos;
        long measuredRenewPeriodMillis;
        long elapsedMillisToRenew = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - renewStart);
        if (elapsedMillisToRenew > expectedRenewPeriodMillis) {
            LOGGER.error((Object)(lockName + " lock renew tooks " + elapsedMillisToRenew + " ms, while is supposed to take <" + expectedRenewPeriodMillis + " ms"));
        }
        if ((measuredRenewPeriodMillis = TimeUnit.NANOSECONDS.toMillis(measuredRenewPeriodNanos = renewStart - lastRenewStart)) > expirationMillis) {
            LOGGER.error((Object)(lockName + " lock renew period lasted " + measuredRenewPeriodMillis + " ms instead of " + expectedRenewPeriodMillis + " ms"));
        } else if (measuredRenewPeriodMillis > expectedRenewPeriodMillis) {
            LOGGER.warn((Object)(lockName + " lock renew period lasted " + measuredRenewPeriodMillis + " ms instead of " + expectedRenewPeriodMillis + " ms"));
        }
    }
}

