/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;

public class AddressInfo {
    public static final SimpleString ADVISORY_TOPIC = new SimpleString("ActiveMQ.Advisory.");
    private long id;
    private final SimpleString name;
    private boolean autoCreated = false;
    private Set<RoutingType> routingTypes;

    public AddressInfo(SimpleString name) {
        this(name, new HashSet<RoutingType>());
    }

    public AddressInfo(SimpleString name, Set<RoutingType> routingTypes) {
        this.name = name;
        this.routingTypes = routingTypes;
    }

    public AddressInfo(SimpleString name, RoutingType routingType) {
        this.name = name;
        this.routingTypes = new HashSet<RoutingType>();
        this.routingTypes.add(routingType);
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public AddressInfo setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
        return this;
    }

    public SimpleString getName() {
        return this.name;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public Set<RoutingType> getRoutingTypes() {
        return this.routingTypes;
    }

    public AddressInfo setRoutingTypes(Set<RoutingType> routingTypes) {
        this.routingTypes = routingTypes;
        return this;
    }

    public AddressInfo addRoutingType(RoutingType routingType) {
        if (this.routingTypes == null) {
            this.routingTypes = new HashSet<RoutingType>();
        }
        this.routingTypes.add(routingType);
        return this;
    }

    public RoutingType getRoutingType() {
        Iterator<RoutingType> iterator = this.routingTypes.iterator();
        if (iterator.hasNext()) {
            RoutingType routingType = iterator.next();
            return routingType;
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Address [name=" + this.name);
        buff.append(", id=" + this.id);
        buff.append(", routingTypes={");
        for (RoutingType routingType : this.routingTypes) {
            buff.append(routingType.toString() + ",");
        }
        if (buff.charAt(buff.length() - 1) == ',') {
            buff.deleteCharAt(buff.length() - 1);
        }
        buff.append("}");
        buff.append(", autoCreated=" + this.autoCreated);
        buff.append("]");
        return buff.toString();
    }

    public boolean isInternal() {
        return this.name.startsWith(ADVISORY_TOPIC);
    }
}

