/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ConsumerFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ConsumerView
extends ActiveMQAbstractView<ServerConsumer> {
    private static final String defaultSortColumn = "creationTime";
    private final ActiveMQServer server;

    public ConsumerView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ConsumerFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return ServerConsumer.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerConsumer consumer) {
        ServerSession session = this.server.getSessionByID(consumer.getSessionID());
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("id", this.toString(consumer.sequentialID())).add("session", this.toString(session.getName())).add("clientID", this.toString(session.getRemotingConnection().getClientID())).add("user", this.toString(session.getUsername())).add("protocol", this.toString(session.getRemotingConnection().getProtocolName())).add("queue", this.toString(consumer.getQueue().getName())).add("queueType", this.toString(consumer.getQueue().getRoutingType()).toLowerCase()).add("address", this.toString(consumer.getQueue().getAddress().toString())).add("localAddress", this.toString(session.getRemotingConnection().getTransportConnection().getLocalAddress())).add("remoteAddress", this.toString(session.getRemotingConnection().getTransportConnection().getRemoteAddress())).add(defaultSortColumn, new Date(consumer.getCreationTime()).toString());
        return obj;
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

